package sample;

import mokit.exception.MktIOException;
import mokit.exception.MktUIException;
import mokit.io.HttpManager;
import mokit.io.HttpReceivedEvent;
import mokit.io.PropertyReader;
import mokit.io.StoreManager;
import mokit.ui.BaseCanvas;
import mokit.ui.G;
import mokit.ui.SoundData;
import mokit.ui.SoundPlayer;
import mokit.util.ByteUtil;
import mokit.util.DebugUtil;

/**
 * FTEht@C̓pbP[WɊ܂܂ĂȂ̂ŎƗ܂B
 */

public class CvsTest extends BaseCanvas implements HttpReceivedEvent {

	// \tgL[`
	private static String LABEL_TOP = "gbv";
	private static String LABEL_END_APP = "I";
	
	// J[\ʒu
	private int _x = 0;
	private int _y = 0;

	public CvsTest() {
	
		try{
			 SoundData[] _sound = new SoundData[2];
			 for(int i=0; i<2; i++){
				_sound[i] = new SoundData();
			}
			
			// TEh擾
			_sound[0].setSound("field11.spf");
			_sound[1].setSound("system23.spf");
			
			// Đ
			SoundPlayer.getInstance().setBGM(_sound[0]);
			SoundPlayer.getInstance().setSE(_sound[1]);

		}catch(MktUIException e){
			System.out.println(e.getMessage());			
		}
	}
	
	public void activateCvs() {

		DebugUtil.debug("CvsTest activateCvs()");

		setSoftLabel(LABEL_TOP, LABEL_END_APP);
		
		_x = G.getWidth()/2;
		_y = G.getHeight()/2;
	}

	public void paintCvs() {
		
		StringBuffer str = new StringBuffer();
		str.append("<s=small><b>W[eXg</b></s><br> <br>");
		str.append("[] WEB<br>");
		str.append("[*,#] ؾ<br>");
		str.append("[0] ۸ý<br>");
		str.append("[1] èý<br>");
		str.append("[2] ׯ߯ý<br>");
		str.append("[3] ý1<br>");
		str.append("[4] ý2<br>");
		str.append("[5] HTTPý");
		
		G.clearAll();
		G.setColorRGB(0,0,0);
		G.drawTagString(new String(str), 20, 20, 200, 20);		
		
		G.setColorRGB(0,0,255);
		G.drawString("{", _x, _y);
		G.drawString("{", _x+1, _y);
	}

	public void exe(int keyEvent, int keyState) {

		// \tgL[
		if(keyEvent == KEY_SOFT1){
			endCvsThread(Main.MODE_TITLE);
		}
		if(keyEvent == KEY_SOFT2){
			endCvsThread(Main.MODE_END_APP);
		}

		// L[
		if(checkKey(UP)){
			_y -= 5;
			if(_y <= 0) _y = G.getHeight();
		}
		if(checkKey(DOWN)){
			_y += 5;
			if(_y >= G.getHeight()) _y = 0;
		}
		if(checkKey(RIGHT)){
			_x += 5;
			if(_x >= G.getWidth()) _x = 0;
		}
		if(checkKey(LEFT)){
			_x -= 5;
			if(_x <= 0) _x = G.getWidth();
		}

		// L[
		if(checkMultiKey(KEY_AST, KEY_PND)){
			_x = G.getWidth() / 2;
			_y = G.getHeight() / 2;
		}

		// @\`FbN
		if(keyEvent == SELECT){
			Main.execBrowser(new String[]{"http://www.google.com"});
		}
		if(keyEvent == KEY_0){
			logTest();
		}
		if(keyEvent == KEY_1){
			propertyTest();
		}
		if(keyEvent == KEY_2){
			storeTest();
		}
		if(keyEvent == KEY_3){
			soundTest1();
		}
		if(keyEvent == KEY_4){
			soundTest2();
		}
		if(keyEvent == KEY_5){
			httpTest();
		}
	}
	
	private void logTest(){
		System.out.println("\n=== logTest ===");

		DebugUtil.system("system message");
		DebugUtil.debug("debug message");
		DebugUtil.warn("warning message");
		DebugUtil.fatal("fatal message");
		DebugUtil.show(DebugUtil.getAllLog());
		DebugUtil.showMemory();
	}
	
	private void propertyTest() {
		System.out.println("\n=== propertyTest ===");

		PropertyReader property = new PropertyReader();
		try{
			property.readResource("sample.property");
			String[] k = property.getKeys();

			System.out.println("ykeysz");
			for(int i = 0; i < k.length; i++){
				System.out.println(k[i]);
			}

			System.out.println("\nyvaluesz");
			System.out.println(property.getString("category1.msg1"));
			System.out.println(property.getString("category2.msg1"));
			System.out.println(property.getString("category3.msg1"));

		}catch(MktIOException e1){
			e1.printStackTrace();
		}
	}

	private void soundTest1() {
		System.out.println("\n=== soundTest1 ===");
		SoundPlayer.getInstance().play(SoundPlayer.BGM);
	}

	private void soundTest2() {
		System.out.println("\n=== soundTest2 ===");
		SoundPlayer.getInstance().play(SoundPlayer.SE);
	}

	private void storeTest(){
		System.out.println("\n=== storeTest ===");

		// [h
		StoreManager sm = new StoreManager();
		
		byte[] data = ByteUtil.getBytes("MokiteXg");
		try{
			byte[] b = sm.read(StoreManager.NO_1, 0, data.length);
			System.out.println(ByteUtil.byte2Str(b));
		}catch(Exception e){
			System.out.println(e.getMessage());
		}

		// Z[u
		try{
			sm.write(data, StoreManager.NO_1, 0);
		}catch(Exception e){
			System.out.println(e.getMessage());		
		}
	}

	private void httpTest() {
		System.out.println("\n=== httpTest ===");

		HttpManager http = HttpManager.getInstance();
		http.initQueThread();

		System.out.println("yL[Jnz");
		try{
			http.push(this, "test.gif", null, new String[]{"L[ test.gif"});
			http.push(this, "test.txt", null, new String[]{"L[ test.txt"});
		}catch(Exception e){
			System.out.println(e.getMessage());
		}

		System.out.println("y荞݊Jnz");
		try{
			byte[] data = http.requestHttp("test.txt");
			System.out.println("荞 test.txt " + data.length + "byte");
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}

	public void httpReceived(byte[] data, String[] option) {

		System.out.println(option[0] + " " + data.length + "byte");
	}

	public void httpErrReceived(String message, String[] option) {

		System.out.println(option[0] + " " + message);
	}

}
