package sample.block;

import sample.CvsGame;
import mokit.exception.MktUIException;
import mokit.ui.G;
import mokit.ui.MktImage;

public class Bar {

	// 摜̕
	private int w = 40;

	// 摜̍
	private int h = 8;

	// 摜̕\ʒuX	
	private int x;

	// 摜̕\ʒuY	
	private int y;

	// Xړx
	private int speed;

	// 摜CX^X
	private MktImage img;

	public Bar() {

		img = new MktImage();
		try{
			img.setImage("bar.png");
			img.setTransparent(255, 255, 255);
		}catch(MktUIException e){
			e.printStackTrace();
		}

		init();
	}
	
	public void init(){

		x = (CvsGame.FRAME_SX + CvsGame.FRAME_WIDTH) / 2 - w / 2;
		y = 220;
		speed = 7;
	}

	public void paint() {

		G.drawImage(img, x, y);
	}

	public int[] getSize() {

		return new int[]{x, y, w, h};
	}

	public int moveLeft() {

		if(x - speed > CvsGame.FRAME_SX){
			x -= speed;
			return -speed;
		}
		return 0;
	}

	public int moveRight() {

		if(x + speed < CvsGame.FRAME_SX + CvsGame.FRAME_WIDTH - w){
			x += speed;
			return speed;
		}
		return 0;
	}
}
