package mokit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

import javax.microedition.io.Connector;

import mokit.exception.MktIOException;
import mokit.ui.BaseMain;
import mokit.util.ByteUtil;

import com.docomostar.io.ConnectionException;
import com.docomostar.io.HttpConnection;

/**
 * HTTPʐMs߂̋@\񋟂܂B<br>
 * [͓ɕ̃RlNV𒣂Ȃ߁AHTTPNGXg L[ǗĂ܂B<br>
 * ̃RlNV𒣂KvȂꍇA荞ݒʐMKvȏꍇ́ANGXg\bh
 * PƂŎsĂB<br>
 * <br>
 * [Doja]<br>
 * ADFUseNetwork=http w肷Kv܂B<br>
 * 
 * @author Takuto Nishioka
 */
public class HttpManager extends Thread {

	// VOgpCX^X
	private static HttpManager _manager;

	// HTTPʐMΏۃL[
	private Vector _que;

	// HTTPʐMXbhN
	private boolean _isRun;

	// HTTPʐMXbhҋ@
	private static final int WAIT_QUE = 1000;

	/**
	 * HttpManagerCX^Xݒ肵܂B
	 */
	private HttpManager() {

		if (_manager == null) {
			_manager = this;
		}
	}

	/**
	 * HttpManagerCX^X擾܂B
	 * 
	 * @return HttpManagerCX^XԂ܂B
	 */
	public static HttpManager getInstance() {

		if (_manager == null) {
			new HttpManager();
		}
		return _manager;
	}

	/**
	 * HTTPʐMXbhJn܂B
	 */
	public void initQueThread() {

		//ɊJnĂΉȂ
		if (_isRun && _que != null) return;

		_que = new Vector();
		_isRun = true;
		this.start();
	}

	/**
	 * HTTPʐMXbh~܂B
	 */
	public void stopQueThread() {

		_isRun = false;
	}

	/**
	 * HTTPʐML[ɃNGXgǉ܂B<br>
	 * <br>
	 * L̏ꍇɂ̓NGXg͔j܂B<br>
	 * EL[ĂȂꍇ<br>
	 * EXbh~vɎsꂽꍇ<br>
	 * 
	 * @param reciever
	 *          HTTPMCxg󂯎CX^X
	 * @param url
	 *          ʐMURL
	 * @param post
	 *          POSTp^ iPARAM1=VALUE1&...j
	 * @param option
	 *          Mf[^ƋɕԂf[^
	 * @throws MktIOException
	 *           L[ĂȂꍇɔ܂B
	 */
	public void push(HttpReceivedEvent reciever, String url, String post, String[] option) throws MktIOException {

		if (_que == null) {
			throw new MktIOException(MktIOException.HTTP_QUE_HASNOT_INITIALISED, "[push-null] url=" + url + ", post=" + post);
		}
		_que.addElement(new HttpQue(reciever, url, post, option));
	}

	/**
	 * HTTPʐML[烊NGXg擾܂B
	 * 
	 * @return HttpQueCX^XԂ܂B
	 */
	private HttpQue pop() {

		HttpQue httpque = (HttpQue) _que.elementAt(0);
		_que.removeElementAt(0);

		return httpque;
	}

	/**
	 * HTTPʐML[ɃNGXg邩`FbN܂B
	 * 
	 * @return NGXgcĂtrueԂ܂B
	 */
	public boolean hasQue() {

		if (_que == null) return false;
		return (_que.size() > 0) ? true : false;
	}

	/**
	 * HTTPʐMXbhB<br>
	 * HTTPʐML[ɒǉꂽNGXg܂B<br>
	 * <br>
	 * ʐMꍇ́AhttpReceived()<br>
	 * ʐMsꍇ́AhttpErrReceived()<br>
	 * ꂼĂ΂܂B
	 */
	public void run() {

		while (_isRun) {
			if (hasQue()) {
				HttpQue httpque = pop();
				try {
					byte[] ret = requestHttp(httpque.getUrl(), httpque.getPostPrm());
					httpque.getReciever().httpReceived(ret, httpque.getOption());

				} catch (Exception e) {
					httpque.getReciever().httpErrReceived(e.getMessage(), httpque.getOption());
				}

				//L[Ȃҋ@
			} else {
				try {
					Thread.sleep(WAIT_QUE);
				} catch (Exception e) {
				}
			}
		}
		_que = null;
	}

	/**
	 * GETʐMs܂B <br>
	 * L[ʐMɒPƂŎsꂽꍇɂ͊荞ݒʐMs܂B<br>
	 * ʐMURLɂ́ABaseMain.getPath()Ŏ擾łpXȍ~w肵܂B<br>
	 * 
	 * @param url
	 *          ʐMURL
	 * @return MoCgf[^zԂ܂B
	 * @throws IOException
	 *           f[^MA͏ŃG[ꍇɔ܂B
	 * @throws MktIOException
	 *           ڑɎsꍇAHTTPX|XOKȊȌꍇɔ܂B
	 *           
	 */
	public synchronized byte[] requestHttp(String url) throws IOException, MktIOException {

		return requestHttp(url, null);
	}

	/**
	 * POSTʐMs܂B <br>
	 * L[ʐMɒPƂŎsꂽꍇɂ͊荞ݒʐMs܂B<br>
	 * ʐMURLɂ́ABaseMain.getPath()Ŏ擾łpXȍ~w肵܂B<br>
	 * 
	 * @param url
	 *            ʐMURL
	 * @param post
	 *            POSTp^ iPARAM1=VALUE1&...j
	 * @return MoCgf[^zԂ܂B
	 * @throws IOException
	 *             f[^MA͏ŃG[ꍇɔ܂B
	 * @throws MktIOException
	 *             ڑɎsꍇAHTTPX|XOKȊȌꍇɔ܂B
	 */
	public synchronized byte[] requestHttp(String url, String post) throws IOException, MktIOException {

		url = BaseMain.getPath() + url;
		byte[] ret = null;

		HttpConnection con = null;
		InputStream in = null;

		try {
			// POSTʐM
			if (post != null) {
				con = (HttpConnection) Connector.open(url, Connector.READ_WRITE, true);
				con.setRequestMethod(HttpConnection.POST);
				con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");

				// POSTp^Zbg
				OutputStreamWriter osw = new OutputStreamWriter(con.openOutputStream());
				osw.write(post, 0, post.length());
				osw.close();

			// GETʐM
			} else {
				con = (HttpConnection) Connector.open(url, Connector.READ, true);
				con.setRequestMethod(HttpConnection.GET);
			}

			// ڑ
			con.connect();
			if (con.getResponseCode() != HttpConnection.HTTP_OK) {
				throw new MktIOException(MktIOException.HTTP_STATUS_NOT_OK, "[requestHttp-status] url=" + url + ", post=" + post);
			}

			// f[^M
			in = con.openInputStream();
			ret = ByteUtil.readInputStream(in);
			
			in.close();
			con.close();

		} catch (ConnectionException e) {
			throw new MktIOException(MktIOException.HTTP_CONN_FAILED, "[requestHttp-connection] url=" + url + ", post=" + post);

		} catch (IOException e) {
			throw new IOException("[requestHttp-io] url=" + url + ", post=" + post);

		} finally {
			try {
				if (in != null) in.close();
				if (con != null) con.close();

			} catch (IOException e) {
			}
			in = null;
			con = null;
		}
		return ret;
	}

	/**
	 * HTTPʐML[IuWFNgB
	 * 
	 * @author Takuto Nishioka
	 */
	private class HttpQue {

		private HttpReceivedEvent _reciever;
		private String _url;
		private String _post;
		private String[] _option;

		/**
		 * HTTPʐML[̏`܂B
		 * 
		 * @param receiver
		 *          HTTPCxgMCX^X
		 * @param url
		 *          ʐMURL
		 * @param post
		 *          POSTp^
		 * @param option
		 *          IvVp^
		 */
		public HttpQue(HttpReceivedEvent receiver, String url, String post, String[] option) {

			_reciever = receiver;
			_url = url;
			_post = post;
			_option = option;
		}

		/**
		 * HTTPCxgMCX^XԂ܂B
		 * 
		 * @return HTTPCxgMCX^XԂ܂B
		 */
		public HttpReceivedEvent getReciever() {

			return _reciever;
		}

		/**
		 * ʐMURL擾܂B
		 * 
		 * @return ʐMURLԂ܂B
		 */
		public String getUrl() {

			return _url;
		}

		/**
		 * POSTp^擾܂B<br>
		 * GETʐM̏ꍇNULLԂ܂B
		 * 
		 * @return POSTp^Ԃ܂B
		 */
		public String getPostPrm() {

			return _post;
		}

		/**
		 * IvVp^擾܂B
		 * 
		 * @return IvVp^Ԃ܂B
		 */
		public String[] getOption() {

			return _option;
		}

	}

}
