%define name        reiserfs-module
%define version     0.1.4
%define release     0mol1.rhel4
%define kernel      %(uname -r)

Summary:     ReiserFS Kernel Module
Summary(ja): ReiserFSカーネルモジュール
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     reiserfs-module-%{version}.tar.gz
License:     GNU GPL version2
Group:       System Environment/Kernel
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root
BuildPrereq: mkkmodule

%description
reiserfs-module is a kernel module which provides reiserfs support.

%description -l ja
reiserfs-moduleはreiserfsファイルシステムをサポートするカーネルモジュールです。

%prep
%setup -n reiserfs-module-%{version}

%build
mkkmodule

%install
install -m 0644 -D reiserfs.ko ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/reiserfs/reiserfs.ko
touch ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/reiserfs/reiserfs.ko

%clean
rm -rf ${RPM_BUILD_ROOT}

%package %{kernel}
Summary:     ReiserFS Kernel Module for RHEL
Summary(ja): RHEL用ReiserFSカーネルモジュール
Group:       System Environment/Kernel

%description %{kernel}
reiserfs-module is a kernel module which provides reiserfs support for RHEL.

%description %{kernel} -l ja
reiesrfs-moduleはreiserfsファイルシステムをサポートするRHEL用のカーネルモジュー
ルです。

%files %{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/kernel/fs/reiserfs/reiserfs.ko

%post %{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%postun %{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%changelog
* Sun Apr 23 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- initial build for Make One Linux.

