@echo off
REM Make One Linux on Windows File System
REM Written by Keicho Kondo 2006.06.09
REM Contact: dgel@users.sourceforge.jp
REM License GPL

REM ChangeLog
REM 2007-06-09 Keicho Kondo
REM - Fix for Make One Linux 0.7.0.
REM
REM 2006-04-03 Keicho Kondo
REM - Fix for Make One Linux.

REM Acknowledgements:
REM Original writer is Kniyasu Suzaki & Japanese KNOPPIX TEAM

REM Original ChangeLog
REM
REM 2004 09-07 IIJIMA Knego
REM - Separate a making of menu line into mkmenu.bat.
REM - Add /I option to find.
REM
REM 2004 08-20 Kuniyasu Suzaki
REM - Add English boot menu option.
REM
REM 2004 08-03 IIJIMA kengo
REM - Fix make menu.lst.
REM
REM 2004-07-08 IIJIMA Kengo
REM - Add backup boot.ini to boot.ini.grubback.
REM
REM 2004-07-06 IIJIMA Kengo
REM - Add check drive for boot.ini and menu.lst.
REM - Change GRUBDIR from \boot\grub to \boot.
REM
REM 2004-07-01 IIJIMA Kengo
REM - Add detect root partition.

set GRUBDIR=\boot
set GRUBHOME=%SystemDrive%%GRUBDIR%

set MSG=echo
if EXIST %GRUBHOME%\msgbox.exe set MSG=%GRUBHOME%\msgbox

%SystemDrive%
cd %GRUBDIR%\

REM check boot.ini
if EXIST h:\boot.ini set BOOTDRIVE=h:
if EXIST g:\boot.ini set BOOTDRIVE=g:
if EXIST f:\boot.ini set BOOTDRIVE=f:
if EXIST e:\boot.ini set BOOTDRIVE=e:
if EXIST d:\boot.ini set BOOTDRIVE=d:
if EXIST c:\boot.ini set BOOTDRIVE=c:
set BOOTINI=%BOOTDRIVE%\boot.ini
if not EXIST %BOOTINI% goto ABORT1

:CHECKBOOTINI
find /I "default" %BOOTINI% | find "partition(1)" > nul
if %ERRORLEVEL% equ 0 set PARTITION=0
find /I "default" %BOOTINI% | find "partition(2)" > nul
if %ERRORLEVEL% equ 0 set PARTITION=1
find /I "default" %BOOTINI% | find "partition(3)" > nul
if %ERRORLEVEL% equ 0 set PARTITION=2
find /I "default" %BOOTINI% | find "partition(4)" > nul
if %ERRORLEVEL% equ 0 set PARTITION=3

find /I "default" %BOOTINI% | find "rdisk(0)" > nul
if %ERRORLEVEL% equ 0 set RDISK=0
find /I "default" %BOOTINI% | find "rdisk(1)" > nul
if %ERRORLEVEL% equ 0 set RDISK=1
find /I "default" %BOOTINI% | find "rdisk(2)" > nul
if %ERRORLEVEL% equ 0 set RDISK=2
find /I "default" %BOOTINI% | find "rdisk(3)" > nul
if %ERRORLEVEL% equ 0 set RDISK=3

REM make menu.list
:echo make grub config file.
set CONF=%GRUBHOME%\menu.lst

if EXIST %CONF%.bak del %CONF%.bak
if not EXIST %CONF% goto MAKEMENU
copy %CONF% %CONF%.bak > nul
del %CONF%

:MAKEMENU 
echo default=0 >> %CONF%
echo timeout=10 >> %CONF%
call %GRUBHOME%\mkmenu.bat MakeOneLinux %RDISK% %PARTITION% default %CONF%
call %GRUBHOME%\mkmenu.bat MakeOneLinux %RDISK% %PARTITION% failsafe %CONF%

REM 
REM Setup GRUB if Windows installed
REM
:echo setup grub
%GRUBHOME%\flushdrv > nul
%GRUBHOME%\grubinstall -d %SystemDrive% -1 %GRUBHOME%\stage1 -2 %GRUBHOME%\stage2 -m (hd%RDISK%,%PARTITION%)%GRUBDIR%\menu.lst > %GRUBHOME%\grub-installed.txt
%GRUBHOME%\flushdrv > nul
find "stage2 configured on (hd%RDISK%,%PARTITION%)" %GRUBHOME%\grub-installed.txt > nul
if %ERRORLEVEL% equ 1 goto ABORT2

:BOOTINISETUP
REM 
REM Setup bootloader
REM
attrib -r -h -s %BOOTINI%
find "GNU GRUB for Make One Linux" %BOOTINI% > nul
if %ERRORLEVEL% equ 0 goto RESETATTRIB
if EXIST %BOOTINI%.grubback goto GRUBADD
copy %BOOTINI% %BOOTINI%.grubback > nul
attrib +r +h +s %BOOTINI%.grubback  

:GRUBADD
echo. >> %BOOTINI%
echo %GRUBHOME%\stage1="GNU GRUB for Make One Linux" >> %BOOTINI%

:RESETATTRIB
attrib +r +h +s %BOOTINI%

%MSG% Success "GRUB was successfully installed to Windows."
goto END

:ABORT1
%MSG% Failed "%BOOTINI% not found." 16
goto END

:ABORT2
%MSG% Failed "GRUB failed in installation of stage2." 16
echo Detected root partition was %PARTITION%.
more %GRUBHOME%\grub-installed.txt
pause
goto END

:END
