@echo off
REM KNOPPIX on Windows File System
REM Written by Keicho Kondo 2006.04.03
REM Contact: dgel@users.sourceforge.jp
REM License GPL

REM ChangeLog
REM 2006-04-03 Keicho Kondo
REM - Fix for Make One Linux.

REM Acknowledgements:
REM Original writer is IIJIMA Kengo & Japanese KNOPPIX TEAM

set GRUBDIR=\boot
set GRUBHOME=%SystemDrive%%GRUBDIR%

set MSG=echo
if EXIST %GRUBHOME%\msgbox.exe set MSG=%GRUBHOME%\msgbox

REM check boot.ini
if EXIST h:\boot.ini set BOOTDRIVE=h:
if EXIST g:\boot.ini set BOOTDRIVE=g:
if EXIST f:\boot.ini set BOOTDRIVE=f:
if EXIST e:\boot.ini set BOOTDRIVE=e:
if EXIST d:\boot.ini set BOOTDRIVE=d:
if EXIST c:\boot.ini set BOOTDRIVE=c:
set BOOTINI=%BOOTDRIVE%\boot.ini
if not EXIST %BOOTINI% goto ABORT1

REM 
REM Recover bootloader
REM
attrib -r -h -s %BOOTINI%
if not EXIST %BOOTINI%.grubback goto NOBACK
find "GNU GRUB for Make One Linux" %BOOTINI% > nul
if %ERRORLEVEL% equ 1 goto NOGRUB
attrib -r -h -s %BOOTINI%.grubback
if EXIST %BOOTINI%.new del %BOOTINI%.new
copy %BOOTINI% %BOOTINI%.new > nul
del %BOOTINI%
copy %BOOTINI%.grubback %BOOTINI% > nul
del %BOOTINI%.grubback
attrib +r +h +s %BOOTINI%

%MSG% Success "GRUB was successfully uninstalled from Windows."
goto END

:ABORT1
%MSG% Failed "%BOOTINI% not found." 16
goto END

:NOBACK
attrib +r +h +s %BOOTINI%
%MSG% Failed "%BOOTINI%.grubback note found." 16
goto END

:NOGRUB
attrib +r +h +s %BOOTINI%
%MSG% Failed "no GRUB in %BOOTINI%." 16
goto END

:END
