#include <monapi.h>
#include "IDEDriver.h"
#include <monapi/io.h>

using namespace MonAPI;

#define IRQ_PRIMARY   14
#define IRQ_SECONDARY 15

static int irq;
static IDEDriver* ide;

/*
    ۑ
    VmwareŃfoCXF܂Ȃ
    G[̏ڍׂzRs[œn
    ZN^TCY̎擾
    bufferւ̑ʓǂݍ݂`FbN
    idleʂ悤B
    busy loopƂB
    atapi packet limiẗӖB2048ȂđS̃TCYH
    wordTCY̌E
*/

static void interrupt()
{
    syscall_set_irq_receiver(irq);

    for (MessageInfo msg;;)
    {
        if (MonAPI::Message::receive(&msg) != 0) continue;

        switch (msg.header)
        {
        case MSG_INTERRUPTED:
#if 1
            printf("interrupt irq=%d\n", msg.arg1);
#endif
            ide->protocolInterrupt();
            break;
        default:
            printf("default");
        }
    }
}

/*
  G[ڍׂ\B
*/
static void printError(const byte* error)
{
    for (int i = 0; i < 18; i++)
    {
        printf("erorr[%d]=%x\n", i, error[i]);
    }
}

int MonaMain(List<char*>* pekoe)
{
    if (pekoe->size() != 1)
    {
        return 0;
    }

    syscall_get_io();

    ide = new IDEDriver();

    /* find CD-ROM */
    int controller, deviceNo;
    if (!ide->findDevice(IDEDriver::DEVICE_ATAPI, 0x05, &controller, &deviceNo))
    {
        printf("CD-ROM Not Found\n");
        delete ide;
        return 1;
    }

    /* set irq number */
    if (controller == IDEDriver::PRIMARY)
    {
        irq = IRQ_PRIMARY;
        outp8(0xa1, inp8(0xa1) & 0xbf);
    }
    else
    {
        irq = IRQ_SECONDARY;
        outp8(0xa1, inp8(0xa1) & 0x7f);
    }

    /* interrupt thread */
    dword id = syscall_mthread_create((dword)interrupt);
    syscall_mthread_join(id);

    if (!ide->selectDevice(controller, deviceNo))
    {
        printf("select device NG error code = %d\n", ide->getLastError());
        delete ide;
        return 1;
    }

    dword lba = atoi(pekoe->get(0));
    byte buffer[2048];
    int readResult = ide->read(lba, buffer, 2048);

    if (readResult != 0)
    {
        printf("Read Error = %d\n", readResult);
        delete ide;
        return 1;
    }

    printf("[read start]\n");
    char buf[8];
    for (int i = 0; i < 128; i++)
    {
        for (int j = 0; j < 16; j++)
        {
            sprintf(buf, "%02x ", buffer[i * 16 + j]);
            printf(buf);
        }

        printf(" | ");
        for (int j = 0; j < 16; j++)
        {
            sprintf(buf, "%c", buffer[i * 16 + j]);
            printf(buf);
        }
        printf("\n");
    }
    printf("\n[read end]\n");

    delete ide;
    return 0;
}
