/*!
    \file   MoArp.cpp
    \brief  ARPvgRNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.5 $
    \date   create:2004/08/28 update:$Date: 2004/11/23 14:29:04 $
*/

/*! \class MoArp
 *  \brief ARPvgRNX
 */



#include "MoArp.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"

/*!
    \brief initialize
         MoArp RXgN^
    \author Yamami
    \date   create:2004/08/28 update:
*/
MoArp::MoArp()
{
    //ARPLbV
    ArpCache = new HashMap<byte*>(ARP_CACHE_NUM);
    //ARPv҂Xg
    macWaitList = new HList<MAC_REPLY_WAIT*>();
}

/*!
    \brief initialize
         MoArp initArp
    \author Yamami
    \param  AbstractMonic *pminsNic [in] NICNXւ̃|C^
    \date   create:2004/08/28 update:
*/
void MoArp::initArp(AbstractMonic *pminsNic ) 
{
    //NICNXێ
    insAbstractNic = pminsNic;
    return;
}


/*!
    \brief initialize
         MoArp fXNgN^
    \author Yamami
    \date   create:2004/08/28 update:
*/
MoArp::~MoArp() 
{

}


/*!
    \brief receiveArp
         ARPvgRM 
    \param  ARP_HEADER *arpHead [in] ARPwb_ւ̃|C^
    \return int  
        
    \author Yamami
    \date   create:2004/08/28 update:$Date: 2004/11/23 14:29:04 $
*/
int MoArp::receiveArp(ARP_HEADER *arpHead)
{
    
    int rest=0;
    
    // IP̊mF
    // IP̗vŖ΁AȂB
    if(arpHead->dstIp!=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() )){
        return 0;
    }

    // Iy[VR[h̊mF
    switch(MoPacUtl::swapShort(arpHead->opeCode))
    {
        //ARPv
        case OPE_CODE_ARP_REQ:
            transArp(arpHead->srcIp,arpHead->srcMac, OPE_CODE_ARP_REP);
            
            //v󂯂ALbVɓo^
            addArpCache(arpHead->srcIp,arpHead->srcMac); 
            
            break;
            
        //ARP
        case OPE_CODE_ARP_REP:
            rest=receiveReply(arpHead->srcIp,arpHead->srcMac);
            break;
        
        //RARPv
        case OPE_CODE_RARP_REQ:
        //RARP
        case OPE_CODE_RARP_REP:
            break;
    }

    return rest;

}



/*!
    \brief receiveReply
         ARPM
    \param  dword srcip [in] MIPAhX
    \param  byte *mac [in] MMACAhX
    \return void  
        
    \author Yamami
    \date   create:2004/11/15 update:$Date: 2004/11/23 14:29:04 $
*/
int MoArp::receiveReply(dword srcip,byte *mac)
{
    
    MAC_REPLY_WAIT* nowWait;
    int findFlag = 0;
    
    //ARPv҂Xǧ
    for (int i = 0; i < macWaitList->size() ; i++) {
        nowWait = macWaitList->get(i);
        
        nowWait->wait++;
        if(nowWait->ip == srcip){
            //v҂IPȂ
            //MACAhXRs[
            memcpy(nowWait->mac ,mac ,6);
            nowWait->repFlg = 1;

            //ARPLbVo^
            addArpCache(srcip,mac); 
            
            //findFlagI
            findFlag = 1;
        }
    }
    
    if(findFlag == 1){
        //MonesgփbZ[Wʒm
        MessageInfo info;
        dword targetID = Message::lookupMainThread("MONES.EX2");  //TO DO ̒TǂȂȁ[
        // create message
        Message::create(&info, MSG_MONES_WAKEUP_ARP_WAIT, 0, 0, 0, NULL);
        Message::send(targetID, &info);
    }
    
    return 0;
}


//static char broadcastMac[]={0xff,0xff,0xff,0xff,0xff,0xff};
static byte broadcastMac[]={0xff,0xff,0xff,0xff,0xff,0xff};

/*!
    \brief transArp
         ARPM (ARPAARPv)
    \param  dword dstip [in] MIPAhX
    \param  byte *dstmac [in] MMACAhX
    \param  word opecode [in] Iy[VR[h
    \return void  
        
    \author Yamami
    \date   create:2004/08/28 update:$Date: 2004/11/23 14:29:04 $
*/
void MoArp::transArp(dword dstip, byte *dstmac, word opecode)
{
    ARP_HEADER head;

    //p ARPwb_t[쐬
    head.hardType=MoPacUtl::swapShort(HARD_TYPE_ETHER);
    head.protType=MoPacUtl::swapShort(PROT_TYPE_IP);
    head.hardAddrLen=6;
    head.protAddrLen=4;
    head.opeCode=MoPacUtl::swapShort(opecode);
    memcpy(head.srcMac,insAbstractNic->ether_mac_addr,6);
    head.srcIp=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() );
    if(memcmp(dstmac,broadcastMac,6)==0){
        head.srcIp=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr() );
    }else{
        memcpy(head.dstMac,dstmac,6);
    }
    head.dstIp=dstip;  //͎󂯎܂ܕԋp̂ŁAGfBAϊ͕sv

    //M ł́AڃhCoR[
    insAbstractNic->frame_output((byte *)&head , dstmac , sizeof(head) , ETHER_PROTO_ARP);

}


/*!
    \brief addArpCache
         ARPLbVo^
    \param  dword ip [in] o^IPAhX
    \param  char *mac [in] o^MACAhX
    \return void  
        
    \author Yamami
    \date   create:2004/09/19 update:$Date: 2004/11/23 14:29:04 $
*/
void MoArp::addArpCache(dword ip, byte *mac)
{

    char IpKey[10];    //IPAhXL[
    
    byte* setMac;
    
    setMac = new byte(6);
    memcpy(setMac,mac,6);

    //IPAhXAMAP̃L[(String)
    sprintf(IpKey , "%08x",ip);
    ArpCache->put(IpKey , setMac);

}


/*!
    \brief searchCache
         ARPLbV
    \param  dword ip [in] o^IPAhX
    \return char *mac [in] MACAhX ȂꍇNULL
        
    \author Yamami
    \date   create:2004/09/19 update:$Date: 2004/11/23 14:29:04 $
*/
byte* MoArp::searchCache(dword ip)
{
    char IpKey[10];    //IPAhXL[
    byte *RetMacValue;
    
    //HashMap猟
    //IPAhXAMAP̃L[(String)
    sprintf(IpKey , "%08x",ip);
    RetMacValue = ArpCache->get(IpKey);

    return RetMacValue;
}




/*!
    \brief getMac
         ARP IPAhX
    \param  dword ip [in] IPAhX
    \param  byte *mac [OUT] MACAhXւ̃|C^
    \return int 0:LbVqbg 0ȊO:ARPvȂ҂ԍ
        
    \author Yamami
    \date   create:2004/09/20 update:$Date: 2004/11/23 14:29:04 $
*/
int MoArp::getMac(dword ip,byte *mac)
{
    MAC_REPLY_WAIT* nowWait;
    int waitNumber;
    
    enum{
        RETRY_COUNT=3,          // gCM
        REQUEST_TIMEOUT=2000,   // NGXg^CAEg~b
    };

    byte *retmac;
    

    // LbV
    if((retmac=searchCache(ip))!=NULL)
    {
        //LbV猩΁AԂB
        memcpy(mac,retmac,6);
        return 0;
    }


    //LbVɖ̂ARPv

    // M ҂Xgɓo^
    nowWait = new MAC_REPLY_WAIT();
    
    nowWait->ip=ip;
    nowWait->repFlg=0;
    nowWait->wait=0;

    //҂Xgɒǉ
    macWaitList->add(nowWait);
    //҂ԍ̎擾
    //TO DO Yamami!!! XbhZ[tɂȂƂ΂EEE
    waitNumber = macWaitList->size();

    // NGXgARP𑗐M
    //u[hLXgŁAARPv
    transArp(ip,broadcastMac,OPE_CODE_ARP_REQ);
    
    // ҂ԍԋp
    return waitNumber;

}

