/*!
    \file  Fat12.cpp
    \brief Fat12

    Copyright (c) 2005 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision$
    \date   create:2005/03/26 update:$Date$
*/

#include "Fat12.h"

namespace FatFS
{

/*----------------------------------------------------------------------
    Fat12
----------------------------------------------------------------------*/
Fat12::Fat12(byte* fat)
{
    this->fat = fat;
}

Fat12::~Fat12()
{
    delete[] this->fat;
}

dword Fat12::GetNextCluster(dword cluster)
{
    dword index = cluster + cluster / 2;
    dword next;

    if (cluster & 0x01)
    {
        next = (fat[index+1] << 4) + (fat[index] >> 4);
    }
    else
    {
        next = ((fat[index+1] & 0x0f) << 8) + fat[index];
    }
    return next;
}

bool Fat12::GetClusterFromChain(dword startCluster, dword count, dword* found)
{
    dword foundCluster = startCluster;
    dword prevCluster  = startCluster;

    for (dword i = 0; i < count; i++)
    {
        foundCluster = GetNextCluster(prevCluster);

        if (foundCluster == prevCluster) return false;
        prevCluster = foundCluster;
    }

    *found = foundCluster;
    return true;
}

}; /* namespace FatFS */
