/*!
    \file  Fat12.h
    \brief Fat12

    Copyright (c) 2005 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision$
    \date   create:2005/03/26 update:$Date$
*/

#ifndef _FAT12_
#define _FAT12_

#include "types.h"

namespace FatFS
{
/*----------------------------------------------------------------------
    Fat12
----------------------------------------------------------------------*/
class Fat12
{
public:
    Fat12(byte* fat);
    virtual ~Fat12();

public:
    dword GetNextCluster(dword cluster);
    bool GetClusterFromChain(dword startCluster, dword count, dword* foundCluster);

private:
    byte* fat;
};



/*----------------------------------------------------------------------
    Boot Parameter block
----------------------------------------------------------------------*/
#pragma pack(1)
typedef struct Bpb
{
    byte jumpBoot[3];
    byte sysName[8];
    word bytesPerSector;
    byte sectorsPerCluster;
    word reservedSectors;
    byte fatCount;
    word maxRootEntries;
    word totalSectors1;
    byte mediaDescriptor;
    word sectorsPerFAT;
    word sectorsPerTrack;
    word headCount;
    dword hiddenSectors;
    dword totalSectors2;
    byte driveNumber;
    byte reserved1;
    byte extBootSignature;
    dword volumeSerial;
    byte volumeLabel[11];
    byte reserved2[8];
};
#pragma pack(0)

#pragma pack(1)
typedef struct DirectoryEntry
{
    byte filename[8];
    byte extension[3];
    byte attributes;
    byte reserved[10];
    word time;
    word date;
    word startCluster;
    dword fileSize;
};
#pragma pack(0)


};

#endif
