/*!
    \file  Fat12Directory.h
    \brief Fat12Directory

    Copyright (c) 2005 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision$
    \date   create:2005/03/26 update:$Date$
*/

#ifndef _FAT12_DIRECTORY_
#define _FAT12_DIRECTORY_

#include "Directory.h"
#include "HList.h"

namespace FatFS
{

/*----------------------------------------------------------------------
    Fat12Directory
----------------------------------------------------------------------*/
class Fat12Directory : public Directory
{
public:
    Fat12Directory() {}
    virtual ~Fat12Directory() {}

public:
    virtual bool IsDirectory() {return true;}
    virtual dword GetSize() {return 0;}
    virtual MonAPI::CString GetName()   {return this->name;}
    virtual FileDate* GetCreateDate()   {return &createDate;}
    virtual FileDate* GetModifiedDate() {return &modifiedDate;}

public:
    virtual void SetName(MonAPI::CString name) {this->name = name;}
    virtual void SetCluster(dword cluster) {this->cluster = cluster;}
    virtual dword GetCluster() const {return this->cluster;}
public:
    Fat12Directory* parent;
    HList<FileSystemEntry*> children;

private:
    MonAPI::CString name;
    FileDate createDate;
    FileDate modifiedDate;
    dword cluster;
};

} /* FatFS */

#endif
