/*!
    \file  Fat12File.cpp
    \brief Fat12File

    Copyright (c) 2005 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision$
    \date   create:2005/03/26 update:$Date$
*/

#include "Fat12File.h"
#include <string.h>
#include <stdio.h>

using namespace MonAPI;

namespace FatFS
{

/*----------------------------------------------------------------------
    Fat12File
----------------------------------------------------------------------*/
Fat12File::Fat12File(Fat12FileSystem* fs)
{
    this->fs        = fs;
    this->pointer   = 0;
}

Fat12File::~Fat12File()
{
}

dword Fat12File::Read(void* buffer, dword size)
{
    if (fs->ReadClusterChain(this->cluster, pointer, buffer, size))
    {
        return size;
    }
    else
    {
        return 0;
    }
}

dword Fat12File::Write(void* buffer, dword size)
{
    return 0;
}

bool Fat12File::Seek(dword position, dword flag)
{
    if (SEEK_SET == flag)
    {
        if (position < 0)
        {
            this->pointer = 0;
        }
        else
        {
            this->pointer = position;
        }
    }
    else if (SEEK_CUR == flag)
    {
        this->pointer += pointer;
        if (0 > position)
        {
            if (this->pointer < (dword)-position)
            {
                this->pointer = 0;
            }
        }
    }
    else if (SEEK_END == flag)
    {
        this->pointer = this->size + this->pointer;
        if (0 > this->pointer)
        {
            if (this->size < (dword)-position)
            {
                this->pointer = 0;
            }
        }
    }

    if (this->pointer > this->size) this->pointer = this->size;

    return true;
}

} /* namespace FatFS */
