die if @ARGV != 4;
($g_tool, $g_src, $g_iso, $g_out) = @ARGV;
die if !-d $g_src;
@month = ("Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
readfat12(".", $g_out);

sub readfat12
{
	my ($src, $dest) = @_;
	foreach (`$g_tool $g_iso ls -l $src`)
	{
		chop while ord(substr($_, -1)) < 32;
		next if !/^(.+?) (.+) (.+?)$/;
		my ($size, $time, $name) = ($1, $2, $3);
		next if $name =~ /^\./;
		my $f = "$g_src/$src/$name";
		if ($name =~ /^(.*)\/$/)
		{
			die if !-d $f;
			readfat12("$src/$1", "$dest/$1");
		}
		else
		{
			my @st = stat($f);
			die if $st[7] != $size;
			my ($s, $min, $h, $d, $m, $y) = localtime($st[9]);
			$y += 1900 if $y < 1900;
			die if not $time =~ "$month[$m] $d $y.*";
			system "mkdir -p $dest" if !-d $dest;
			my $cmd = "$g_tool $g_iso cp $src/$name $dest/$name";
			print "$cmd\n";
			die if system $cmd;
		}
	}
}
