/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.WalletPassphrase;
import org.monache.lib.api.result.WalletPassphraseResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

public class WalletPassphraseImpl
extends AbstractCoinAPI
implements WalletPassphrase {
    protected static final String METHOD = "walletpassphrase";

    public WalletPassphraseResult call(JsonRPCClient jsonRPCClient, String passphrase, Integer timeout) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (passphrase == null) {
                throw new NullPointerException("passphrase is null.");
            }
            if (timeout == null) {
                throw new NullPointerException("timeout is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            requestObject.setParams(new Object[]{passphrase, timeout});
            JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
            WalletPassphraseResult result = new WalletPassphraseResult();
            result.setJsonString(responseObject.getJsonString());
            return result;
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

