/*
 * CoinAPIFactory.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

/**
 * 暗号通貨用APIオブジェクトを生成するクラス。
 * 
 * @author monache.org
 * @since 1.0
 */
public abstract class CoinAPIFactory {

	/**
	 * {@link WalletPassphrase}を実装したオブジェクトを取得します。
	 * @return WalletPassphraseオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract WalletPassphrase getWalletPassphrase() throws CoinAPIException ;

	/**
	 * {@link WalletLock}を実装したオブジェクトを取得します。
	 * @return WalletLockオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract WalletLock getWalletLock() throws CoinAPIException ;

	/**
	 * {@link GetNewAddress}を実装したオブジェクトを取得します。
	 * @return GetNewAddressオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract GetNewAddress getGetNewAddress() throws CoinAPIException ;

	/**
	 * {@link GetBalance}を実装したオブジェクトを取得します。
	 * @return GetBalanceオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract GetBalance getGetBalance() throws CoinAPIException;

	/**
	 * {@link SendToAddress}を実装したオブジェクトを取得します。
	 * @return SendToAddressオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract SendToAddress getSendToAddress() throws CoinAPIException;

	/**
	 * {@link SendFrom}を実装したオブジェクトを取得します。
	 * @return SendFromオブジェクト
	 * @throws CoinAPIException オブジェクトの生成に失敗
	 * @since 1.0
	 */
	public abstract SendFrom getSendFrom() throws CoinAPIException;

}
