/*
 * GetBalance.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

import org.monache.lib.api.result.GetBalanceResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * getbalance<br>
 * コインの利用残高を取得するAPIです。
 * 
 * @author monache.org
 * @since 1.0
 */
public interface GetBalance extends CoinAPI {

	/**
	 * ウォレット全体の利用残高を取得します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException;

	/**
	 * 任意の口座の利用残高を取得します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param account 口座名(ラベル)
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException;

	/**
	 * @deprecated minconfの未検証
	 * 
	 * 任意の口座の利用残高を取得します。
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param account
	 * @param minconf
	 * @return
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account, Integer minconf) throws CoinAPIException;

}
