/*
 * SendFrom.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api;

import java.math.BigDecimal;

import org.monache.lib.api.result.SendFromResult;
import org.monache.lib.jsonrpc.JsonRPCClient;

/**
 * sendfrom<br>
 * 送金元の口座名を指定して、送金をするAPIです。
 * 
 * @author monache.org
 * @since 1.0
 */
public interface SendFrom extends CoinAPI {

	/**
	 * 送金元の口座名を指定して送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param fromAccount 送金元口座
	 * @param toAddress 送金先アドレス
	 * @param amount 金額
	 * @return 実行結果
	 * @throws CoinAPIException 失敗
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount) throws CoinAPIException;

	/**
	 * @deprecated 未検証 comment commentTo
	 * 送金元の口座名を指定して送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param fromAccount
	 * @param toAddress
	 * @param amount
	 * @param comment
	 * @param commentTo
	 * @return
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException;

	/**
	 * @deprecated 未検証 minconf
	 * 送金元の口座名を指定して送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param fromAccount
	 * @param toAddress
	 * @param amount
	 * @param minconf
	 * @return
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Integer minconf) throws CoinAPIException;

	/**
	 * @deprecated 未検証 minconf comment commentTo
	 * 送金元の口座名を指定して送金します。
	 * 
	 * @param jsonRPCClient JSON-RPCクライアント
	 * @param fromAccount
	 * @param toAddress
	 * @param amount
	 * @param minconf
	 * @param comment
	 * @param commentTo
	 * @return
	 * @throws CoinAPIException
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Integer minconf, String comment, String commentTo) throws CoinAPIException;

}
