/*
 * SendFromImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.SendFrom;
import org.monache.lib.api.result.SendFromResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

/**
 * 
 * 
 * @author monache.org
 * @since 
 */
public class SendFromImpl extends AbstractCoinAPI implements SendFrom {

	protected static final String METHOD = "sendfrom";

	public SendFromImpl() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendFrom#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.String, java.math.BigDecimal)
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient,
			String fromAccount, String toAddress, BigDecimal amount)
			throws CoinAPIException {
		return call(jsonRPCClient, fromAccount, toAddress, amount, null, null, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendFrom#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.String, java.math.BigDecimal, java.lang.String, java.lang.String)
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient,
			String fromAccount, String toAddress, BigDecimal amount,
			String comment, String commentTo) throws CoinAPIException {
		return call(jsonRPCClient, fromAccount, toAddress, amount, null, comment, commentTo);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendFrom#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.String, java.math.BigDecimal, java.lang.Integer)
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient,
			String fromAccount, String toAddress, BigDecimal amount,
			Integer minconf) throws CoinAPIException {
		return call(jsonRPCClient, fromAccount, toAddress, amount, minconf, null, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.SendFrom#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.String, java.math.BigDecimal, java.lang.Integer, java.lang.String, java.lang.String)
	 * @since 1.0
	 */
	public SendFromResult call(JsonRPCClient jsonRPCClient,
			String fromAccount, String toAddress, BigDecimal amount,
			Integer minconf, String comment, String commentTo)
			throws CoinAPIException {
		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (fromAccount == null || fromAccount.length() == 0) {
				throw new NullPointerException("fromAccount is null.");
			}
			if (toAddress == null || fromAccount.length() == 0) {
				throw new NullPointerException("toAddress is null.");
			}
			if (amount == null) {
				throw new NullPointerException("amount is null.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (minconf == null && comment == null && commentTo == null) {
				requestObject.setParams(new Object[]{fromAccount, toAddress, amount});
			} else {
				Object objMinconf = minconf;
				if (objMinconf == null) {
					objMinconf = ARG_UNSPECIFIED;
				}
				if (comment == null) {
					comment = ARG_UNSPECIFIED;
				}
				commentTo = comment;
				if (commentTo == null) {
					commentTo = ARG_UNSPECIFIED;
				}
				requestObject.setParams(new Object[]{fromAccount, toAddress, amount, objMinconf, comment, commentTo});
			}

			// JSON-RPC call
			JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
			
			// Create a GetNewAddress result object
			SendFromResult result = new SendFromResult();
			// JSON string
			result.setJsonString(responseObject.getJsonString());
			// created address
			result.setTransactionId((String)responseObject.getResult());
			return result;

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
