/*
 * MonacheRuntimeException.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.fw;

/**
 * Monacheプロジェクト用のRuntimeException。
 * 
 * @author monache.org
 * @since
 */
public class MonacheRuntimeException extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1876939284705269471L;

	/**
	 * @since 1.0
	 */
	public MonacheRuntimeException() {
		super();
	}

	/**
	 * @param message
	 * @param cause
	 * @since 1.0
	 */
	public MonacheRuntimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 * @since 1.0
	 */
	public MonacheRuntimeException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 * @since 1.0
	 */
	public MonacheRuntimeException(Throwable cause) {
		super(cause);
	}

	
}
