/*
 * NichExecuter.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.nich;

import java.util.ArrayList;
import java.util.List;

import org.monache.nagesen.AddressData;
import org.monache.nagesen.NagesenException;
import org.monache.nagesen.ececuter.AbstractExecuter;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class NichExecuter extends AbstractExecuter {

	public static String NAME_MONACOIN = "monacoin:";
	public static String NAME_KUMACOIN = "kumacoin:";
	
	private GetNichData getNichData = null;

	private String url = null;
	private String lasyModified = null;
	private long range = 0;
	private int statusCode = 0;

	private int startResNo = 0;
	private int endResNo = 0;
	
	private int lastResNo = 0;
	
	/**
	 * 
	 * @since 1.0
	 */
	public NichExecuter() {
	}

	/* (非 Javadoc)
	 * @see org.monache.nagesen.AbstractExecuter#getData()
	 * @since 1.0
	 */
	@Override
	protected List<AddressData> getData() throws NagesenException  {
		
		GetNichDataResult result = getGetNichData().get(getUrl(), getLasyModified(), getRange());
		setStatusCode(result.getStatusCode());
		if (getStatusCode() == GetNichData.STATUS_NOT_FOUND) {
			return null;
		}

		List<AddressData> ret = new ArrayList<AddressData>();
		if (getStatusCode() == GetNichData.STATUS_NOT_MODIFIED) {
			return ret;
		}
		setLasyModified(result.getLasyModified());
		setRange(range + result.getRange());

		for (NichData data : result.getNichDataList()) {
			addLastResNo();
			if (getStartResNo() > getLastResNo() || getEndResNo() < getLastResNo()) {
				continue;
			}
			AddressData data2 = new AddressData();
			if (data.getName().length() != 43) {
				continue;
			}
			
			if (data.getName().startsWith(NAME_MONACOIN) || data.getName().startsWith(NAME_KUMACOIN)) {			
				 data2.setAddress(data.getName().substring(9));
			}
			data2.setCoin(data.getName().substring(0, 8));
			data2.setId(data.getTimestamp().substring(29));
			data2.setMessage(data.getMessage());
			
			ret.add(data2);
		}
		
		return ret;
	}

	
	
	/* (非 Javadoc)
	 * @see org.monache.nagesen.AbstractExecuter#isContinue(org.monache.nagesen.AddressData)
	 * @since 1.0
	 */
	@Override
	protected boolean isContinue(AddressData data) throws NagesenException  {
		if (getStatusCode() == GetNichData.STATUS_NOT_FOUND) {
			return false;
		}
		if (getEndResNo() < getLastResNo()) {
			return false;
		}
		return true;
	}

	
	
	/**
	 * @return url
	 * @since 1.0
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param url セットする url
	 * @since 1.0
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @return getNichData
	 * @since 1.0
	 */
	public GetNichData getGetNichData() {
		return getNichData;
	}

	/**
	 * @param getNichData セットする getNichData
	 * @since 1.0
	 */
	public void setGetNichData(GetNichData getNichData) {
		this.getNichData = getNichData;
	}

	/**
	 * @return lasyModified
	 * @since 1.0
	 */
	public String getLasyModified() {
		return lasyModified;
	}

	/**
	 * @param lasyModified セットする lasyModified
	 * @since 1.0
	 */
	public void setLasyModified(String lasyModified) {
		this.lasyModified = lasyModified;
	}

	/**
	 * @return range
	 * @since 1.0
	 */
	public long getRange() {
		return range;
	}

	/**
	 * @param range セットする range
	 * @since 1.0
	 */
	public void setRange(long range) {
		this.range = range;
	}

	/**
	 * @return statusCode
	 * @since 1.0
	 */
	public int getStatusCode() {
		return statusCode;
	}

	/**
	 * @param statusCode セットする statusCode
	 * @since 1.0
	 */
	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}

	/**
	 * @return lastResNo
	 * @since 1.0
	 */
	public int getLastResNo() {
		return lastResNo;
	}

	/**
	 * @param lastResNo セットする lastResNo
	 * @since 1.0
	 */
	public void setLastResNo(int lastResNo) {
		this.lastResNo = lastResNo;
	}

	public void addLastResNo() {
		setLastResNo(getLastResNo() + 1);
	}

	/**
	 * @return startResNo
	 * @since 1.0
	 */
	public int getStartResNo() {
		return startResNo;
	}

	/**
	 * @param startResNo セットする startResNo
	 * @since 1.0
	 */
	public void setStartResNo(int startResNo) {
		this.startResNo = startResNo;
	}

	/**
	 * @return endResNo
	 * @since 1.0
	 */
	public int getEndResNo() {
		return endResNo;
	}

	/**
	 * @param endResNo セットする endResNo
	 * @since 1.0
	 */
	public void setEndResNo(int endResNo) {
		this.endResNo = endResNo;
	}

}
