/*
 * GetRawTransactionImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetRawTransaction;
import org.monache.lib.api.response.GetRawTransactionResponseObject1;
import org.monache.lib.api.response.GetRawTransactionResponseObject2;
import org.monache.lib.api.result.GetRawTransactionResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetRawTransactionImpl implements GetRawTransaction {

	protected static final String METHOD = "getrawtransaction";

	/**
	 * 
	 * @since 1.0
	 */
	public GetRawTransactionImpl() {
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.GetRawTransaction#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String)
	 * @since 1.0
	 */
	public GetRawTransactionResult call(JsonRPCClient jsonRPCClient,
			String transactionId) throws CoinAPIException {
		return call(jsonRPCClient, transactionId, null);
	}

	/* (非 Javadoc)
	 * @see org.monache.lib.api.GetRawTransaction#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.Long)
	 * @since 1.0
	 */
	public GetRawTransactionResult call(JsonRPCClient jsonRPCClient,
			String transactionId, Long verbose) throws CoinAPIException {
		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (transactionId == null || transactionId.length() == 0) {
				throw new NullPointerException("transactionId is null or empty.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (verbose == null) {
				requestObject.setParams(new Object[]{transactionId});

			} else {
				requestObject.setParams(new Object[]{transactionId, verbose});
			}

			// JSON-RPC call
			if (verbose == null || verbose == 0) {
				return jsonRPCClient.call(requestObject, GetRawTransactionResponseObject2.class).getResultObject();

			} else {
				return jsonRPCClient.call(requestObject, GetRawTransactionResponseObject1.class).getResultObject();
			}

			
		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
