/*
 * GetRawTransactionResponseObject2.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.response;

import org.monache.lib.api.result.GetRawTransactionResult;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetRawTransactionResponseObject2 extends ResponseObject {

	private String result = null;
	
	/**
	 * 
	 * @since 1.0
	 */
	public GetRawTransactionResponseObject2() {
	}

	/**
	 * @return result
	 * @since 1.0
	 */
	public String getResult() {
		return result;
	}

	/**
	 * @param result セットする result
	 * @since 1.0
	 */
	public void setResult(String result) {
		this.result = result;
	}

	public GetRawTransactionResult getResultObject() {
		GetRawTransactionResult result = new GetRawTransactionResult();
		result.setHex(getResult());
		result.setJsonString(getJsonString());
		return result;
	}
}
