/*
 * GetRawTransactionResult.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.result;

import org.monache.lib.json.JsonMember;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetRawTransactionResult {

	private String jsonString = null;

	@JsonMember(name="hex")
	private String hex = null;
	@JsonMember(name="txid")
	private String txid = null;
	@JsonMember(name="version")
	private Long version = null;
	@JsonMember(name="time")
	private Long time = null;
	@JsonMember(name="locktime")
	private Long locktime = null;

	@JsonMember(name="vin")
	private Vin[] vin = null;
	@JsonMember(name="vout")
	private Vout[] vout = null;

	
	@JsonMember(name="blockhash")
	private String blockhash = null;
	@JsonMember(name="confirmations")
	private Long confirmations = null;
	@JsonMember(name="blocktime")
	private Long blocktime = null;

	/**
	 * 
	 * @since 1.0
	 */
	public GetRawTransactionResult() {
		// TODO 自動生成されたコンストラクター・スタブ
	}

	/**
	 * @return jsonString
	 * @since 1.0
	 */
	public String getJsonString() {
		return jsonString;
	}

	/**
	 * @param jsonString セットする jsonString
	 * @since 1.0
	 */
	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	/**
	 * @return hex
	 * @since 1.0
	 */
	public String getHex() {
		return hex;
	}

	/**
	 * @param hex セットする hex
	 * @since 1.0
	 */
	public void setHex(String hex) {
		this.hex = hex;
	}

	/**
	 * @return txid
	 * @since 1.0
	 */
	public String getTxid() {
		return txid;
	}

	/**
	 * @param txid セットする txid
	 * @since 1.0
	 */
	public void setTxid(String txid) {
		this.txid = txid;
	}

	/**
	 * @return version
	 * @since 1.0
	 */
	public Long getVersion() {
		return version;
	}

	/**
	 * @param version セットする version
	 * @since 1.0
	 */
	public void setVersion(Long version) {
		this.version = version;
	}

	/**
	 * @return time
	 * @since 1.0
	 */
	public Long getTime() {
		return time;
	}

	/**
	 * @param time セットする time
	 * @since 1.0
	 */
	public void setTime(Long time) {
		this.time = time;
	}

	/**
	 * @return locktime
	 * @since 1.0
	 */
	public Long getLocktime() {
		return locktime;
	}

	/**
	 * @param locktime セットする locktime
	 * @since 1.0
	 */
	public void setLocktime(Long locktime) {
		this.locktime = locktime;
	}

	/**
	 * @return vin
	 * @since 1.0
	 */
	public Vin[] getVin() {
		return vin;
	}

	/**
	 * @param vin セットする vin
	 * @since 1.0
	 */
	public void setVin(Vin[] vin) {
		this.vin = vin;
	}

	/**
	 * @return vout
	 * @since 1.0
	 */
	public Vout[] getVout() {
		return vout;
	}

	/**
	 * @param vout セットする vout
	 * @since 1.0
	 */
	public void setVout(Vout[] vout) {
		this.vout = vout;
	}

	/**
	 * @return blockhash
	 * @since 1.0
	 */
	public String getBlockhash() {
		return blockhash;
	}

	/**
	 * @param blockhash セットする blockhash
	 * @since 1.0
	 */
	public void setBlockhash(String blockhash) {
		this.blockhash = blockhash;
	}

	/**
	 * @return confirmations
	 * @since 1.0
	 */
	public Long getConfirmations() {
		return confirmations;
	}

	/**
	 * @param confirmations セットする confirmations
	 * @since 1.0
	 */
	public void setConfirmations(Long confirmations) {
		this.confirmations = confirmations;
	}

	/**
	 * @return blocktime
	 * @since 1.0
	 */
	public Long getBlocktime() {
		return blocktime;
	}

	/**
	 * @param blocktime セットする blocktime
	 * @since 1.0
	 */
	public void setBlocktime(Long blocktime) {
		this.blocktime = blocktime;
	}

}
