/*
 * GetTransactionResult.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.result;

import java.math.BigDecimal;

import org.monache.lib.json.JsonMember;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class GetTransactionResult {

	private String jsonString = null;

	// txidとtimeは2つある
	@JsonMember(name="txid")
	private String txid = null;
	@JsonMember(name="version")
	private Long version = null;
	@JsonMember(name="time")
	private Long time = null;
	@JsonMember(name="locktime")
	private Long locktime = null;

	@JsonMember(name="vin")
	private Vin[] vin = null;
	@JsonMember(name="vout")
	private Vout[] vout = null;

	@JsonMember(name="amount")
	private BigDecimal amount = null;
	@JsonMember(name="confirmations")
	private Long confirmations = null;
	@JsonMember(name="blockhash")
	private String blockhash = null;
	@JsonMember(name="blockindex")
	private Long blockindex = null;
	@JsonMember(name="blocktime")
	private Long blocktime = null;
	@JsonMember(name="timereceived")
	private Long timereceived = null;
	@JsonMember(name="comment")
	private String comment = null;
	@JsonMember(name="message")
	private String message = null;
	@JsonMember(name="to")
	private String to = null;

	@JsonMember(name="details")
	private Details[] details = null;

	@JsonMember(name="details")
	private String normtxid = null;
	@JsonMember(name="fee")
	private BigDecimal fee = null;
	
	
	/**
	 * 
	 * @since 1.0
	 */
	public GetTransactionResult() {
		// TODO 自動生成されたコンストラクター・スタブ
	}

	/**
	 * @return jsonString
	 * @since 1.0
	 */
	public String getJsonString() {
		return jsonString;
	}

	/**
	 * @param jsonString セットする jsonString
	 * @since 1.0
	 */
	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	/**
	 * @return txid
	 * @since 1.0
	 */
	public String getTxid() {
		return txid;
	}

	/**
	 * @param txid セットする txid
	 * @since 1.0
	 */
	public void setTxid(String txid) {
		this.txid = txid;
	}

	/**
	 * @return version
	 * @since 1.0
	 */
	public Long getVersion() {
		return version;
	}

	/**
	 * @param version セットする version
	 * @since 1.0
	 */
	public void setVersion(Long version) {
		this.version = version;
	}

	/**
	 * @return time
	 * @since 1.0
	 */
	public Long getTime() {
		return time;
	}

	/**
	 * @param time セットする time
	 * @since 1.0
	 */
	public void setTime(Long time) {
		this.time = time;
	}

	/**
	 * @return locktime
	 * @since 1.0
	 */
	public Long getLocktime() {
		return locktime;
	}

	/**
	 * @param locktime セットする locktime
	 * @since 1.0
	 */
	public void setLocktime(Long locktime) {
		this.locktime = locktime;
	}

	/**
	 * @return vin
	 * @since 1.0
	 */
	public Vin[] getVin() {
		return vin;
	}

	/**
	 * @param vin セットする vin
	 * @since 1.0
	 */
	public void setVin(Vin[] vin) {
		this.vin = vin;
	}

	/**
	 * @return vout
	 * @since 1.0
	 */
	public Vout[] getVout() {
		return vout;
	}

	/**
	 * @param vout セットする vout
	 * @since 1.0
	 */
	public void setVout(Vout[] vout) {
		this.vout = vout;
	}

	/**
	 * @return amount
	 * @since 1.0
	 */
	public BigDecimal getAmount() {
		return amount;
	}

	/**
	 * @param amount セットする amount
	 * @since 1.0
	 */
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	/**
	 * @return confirmations
	 * @since 1.0
	 */
	public Long getConfirmations() {
		return confirmations;
	}

	/**
	 * @param confirmations セットする confirmations
	 * @since 1.0
	 */
	public void setConfirmations(Long confirmations) {
		this.confirmations = confirmations;
	}

	/**
	 * @return blockhash
	 * @since 1.0
	 */
	public String getBlockhash() {
		return blockhash;
	}

	/**
	 * @param blockhash セットする blockhash
	 * @since 1.0
	 */
	public void setBlockhash(String blockhash) {
		this.blockhash = blockhash;
	}

	/**
	 * @return blockindex
	 * @since 1.0
	 */
	public Long getBlockindex() {
		return blockindex;
	}

	/**
	 * @param blockindex セットする blockindex
	 * @since 1.0
	 */
	public void setBlockindex(Long blockindex) {
		this.blockindex = blockindex;
	}

	/**
	 * @return blocktime
	 * @since 1.0
	 */
	public Long getBlocktime() {
		return blocktime;
	}

	/**
	 * @param blocktime セットする blocktime
	 * @since 1.0
	 */
	public void setBlocktime(Long blocktime) {
		this.blocktime = blocktime;
	}

	/**
	 * @return timereceived
	 * @since 1.0
	 */
	public Long getTimereceived() {
		return timereceived;
	}

	/**
	 * @param timereceived セットする timereceived
	 * @since 1.0
	 */
	public void setTimereceived(Long timereceived) {
		this.timereceived = timereceived;
	}

	/**
	 * @return comment
	 * @since 1.0
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * @param comment セットする comment
	 * @since 1.0
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}

	/**
	 * @return message
	 * @since 1.0
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message セットする message
	 * @since 1.0
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return details
	 * @since 1.0
	 */
	public Details[] getDetails() {
		return details;
	}

	/**
	 * @param details セットする details
	 * @since 1.0
	 */
	public void setDetails(Details[] details) {
		this.details = details;
	}

	/**
	 * @return normtxid
	 * @since 1.0
	 */
	public String getNormtxid() {
		return normtxid;
	}

	/**
	 * @param normtxid セットする normtxid
	 * @since 1.0
	 */
	public void setNormtxid(String normtxid) {
		this.normtxid = normtxid;
	}

	/**
	 * @return fee
	 * @since 1.0
	 */
	public BigDecimal getFee() {
		return fee;
	}

	/**
	 * @param fee セットする fee
	 * @since 1.0
	 */
	public void setFee(BigDecimal fee) {
		this.fee = fee;
	}

	/**
	 * @return to
	 * @since 1.0
	 */
	public String getTo() {
		return to;
	}

	/**
	 * @param to セットする to
	 * @since 1.0
	 */
	public void setTo(String to) {
		this.to = to;
	}

	
}
