/*
 * SampleSeaser2.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
import org.monache.lib.api.GetBalance;
import org.monache.lib.api.result.GetBalanceResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;


/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class SampleSeaser2 {

	/**
	 * 
	 * @since 1.0
	 */
	public SampleSeaser2() {
	}

	public static void main(String[] a) {
		new SampleSeaser2().sample();
	}
	public void sample() {

		// サンプル：ウォレットの利用残高を取得する		
		// sample.diconにウォレットの情報や生成オブジェクトの情報を設定する
		S2Container container = S2ContainerFactory.create("sampleseaser2.dicon");
		JsonRPCClient jsonRPC = null;
		try {
			jsonRPC = (JsonRPCClient)container.getComponent(JsonRPCClient.class);
			GetBalance obj = (GetBalance)container.getComponent(GetBalance.class);
			
			// 利用残高の取得
			GetBalanceResult result = obj.call(jsonRPC);
			// 利用残高を表示
			System.out.println(result.getBalance());

		} catch (Exception e) {
			e.printStackTrace();

		} finally {
			try {
				jsonRPC.close();
			} catch (JsonRPCException e) {
				e.printStackTrace();
			}
		}
	}

}
