/*
 * GetNewAddressTestManual1.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.monache.lib.api;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.monache.lib.api.CoinAPIJsonRPCClient;
import org.monache.lib.api.GetNewAddress;
import org.monache.lib.api.impl.DefaultCoinAPIFactory;
import org.monache.lib.api.result.GetNewAddressResult;
import org.monache.lib.httpclient.BasicAuthenticationHttpClient;
import org.monache.lib.httpclient.HttpClient;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

/**
 * 
 * 
 * @version 
 * @author monache.org
 * @since 
 */
public class GetNewAddressTestManual1 {

	static ResourceBundle bundle = null;
	static S2Container container = null;
	static DefaultCoinAPIFactory factory = null;
	static JsonRPCClient jsonRPCS2 = null;
	static JsonRPCClient jsonRPC = null;
	
	/**
	 * 
	 * @throws java.lang.Exception
	 * @since 
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		bundle = ResourceBundle.getBundle("org.monache.lib.api.test-manual1p");

		// seaser2
		container = S2ContainerFactory.create("org/monache/lib/api/test-manual1d.dicon");
		jsonRPCS2 = (JsonRPCClient)container.getComponent(JsonRPCClient.class);

		// factory
		factory = DefaultCoinAPIFactory.newInstance();
		HttpClient httpClient = new BasicAuthenticationHttpClient(
				bundle.getString("host"),
				Integer.parseInt(bundle.getString("port")),
				bundle.getString("user"),
				bundle.getString("password"),
				Integer.parseInt(bundle.getString("connectionTimeout")),
				Integer.parseInt(bundle.getString("socketTimeout")));
		jsonRPC = new CoinAPIJsonRPCClient(
				httpClient, bundle.getString("uri"),
				bundle.getString("schema"),
				bundle.getString("responseCharset").length() == 0 ? null : Charset.forName(bundle.getString("responseCharset")));
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		// seaser2
		jsonRPCS2.close();
		
		// factory
		jsonRPC.close();
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@After
	public void tearDown() throws Exception {
	}

	public static void main(String[] args) throws Exception {
		
		boolean isTestSkip = false;
		if (isTestSkip) {
			System.out.println("test skip GetNewAddressTestManual1.main");
			return;
		}
		
		setUpBeforeClass();
		GetNewAddressTestManual1 test = new GetNewAddressTestManual1();
		test.testS1();
		test.testS2();
		test.testF1();
		tearDownAfterClass();
	}

	
	//JUnitでテストしない 
	// GetNewAddressResult call()
	//@Test
	public void testS1() throws Exception {
		// Seaser2
		GetNewAddress obj = (GetNewAddress)container.getComponent(GetNewAddress.class);
		GetNewAddressResult result = obj.call(jsonRPCS2);
		System.out.println("***** testS1 *********************************");
		System.out.println("address = " + result.getAddress());
		System.out.println("json = " + result.getJsonString());
	}

	//JUnitでテストしない 
	// GetNewAddressResult call(String account)
	//@Test
	public void testS2() throws Exception {
		// Seaser2
		GetNewAddress obj = (GetNewAddress)container.getComponent(GetNewAddress.class);
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
		GetNewAddressResult result = obj.call(jsonRPCS2, "TEST" + format.format(Calendar.getInstance().getTime()));
		System.out.println("***** testS2 *********************************");
		System.out.println("address = " + result.getAddress());
		System.out.println("json = " + result.getJsonString());
	}

	//JUnitでテストしない 
	// GetNewAddressResult call()
	//@Test
	public void testF1() throws Exception {
		// Factory
		GetNewAddress obj = factory.getGetNewAddress();
		GetNewAddressResult result = obj.call(jsonRPC);
		System.out.println("***** testF1 *********************************");
		System.out.println("address = " + result.getAddress());
		System.out.println("json = " + result.getJsonString());
	}

}
