/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractTableTreeView
extends ViewPart {
    private static final String TAG_COLUMNWIDTH = "columnWidth";
    private static final String TAG_COLUMN = "column";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_LABEL = "label";
    private IMemento memento;

    protected abstract Logger getLogger();

    protected abstract TableTreeViewer getViewer();

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract ITableLabelProvider getLabelProvider();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void partCreated() {
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    public void saveState(IMemento memento) {
        this.getLogger().finest("begin");
        if (this.getViewer() == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
        } else {
            this.saveColumnState(memento);
            this.saveExpansionState(memento);
            this.saveSelectionState(memento);
        }
        this.getLogger().finest("done");
    }

    private void saveColumnState(IMemento memento) {
        IMemento widthMem = memento.createChild(TAG_COLUMNWIDTH);
        int i = 0;
        while (i < this.getViewer().getTableTree().getTable().getColumnCount()) {
            IMemento columnMem = widthMem.createChild(TAG_COLUMN);
            columnMem.putInteger(TAG_WIDTH, this.getViewer().getTableTree().getTable().getColumn(i).getWidth());
            ++i;
        }
    }

    private void saveSelectionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_SELECTION), ((IStructuredSelection)this.getViewer().getSelection()).toArray());
    }

    private void saveExpansionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_EXPANDED), this.getViewer().getVisibleExpandedElements());
    }

    private void setElements(IMemento memento, Object[] elements) {
        if (this.getContentProvider() == null) {
            return;
        }
        if (elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                while (this.getContentProvider().getParent(o) != null) {
                    IMemento labelMem = elementMem.createChild(TAG_LABEL);
                    labelMem.putString(TAG_LABEL, this.getLabelProvider().getColumnText(o, 0));
                    o = this.getContentProvider().getParent(o);
                }
                ++i;
            }
        }
    }

    protected void restoreState(IMemento memento) {
        this.getLogger().finest("begin");
        this.restoreColumnState(memento);
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
        this.getLogger().finest("done");
    }

    private void restoreColumnState(IMemento memento) {
        IMemento[] columnMem;
        IMemento widthMem = memento.getChild(TAG_COLUMNWIDTH);
        if (widthMem != null && (columnMem = widthMem.getChildren(TAG_COLUMN)) != null) {
            int i = 0;
            while (i < this.getViewer().getTableTree().getTable().getColumnCount() && i < columnMem.length) {
                this.getViewer().getTableTree().getTable().getColumn(i).setWidth(columnMem[i].getInteger(TAG_WIDTH).intValue());
                ++i;
            }
        }
    }

    private void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(this.getElements(childMem)));
        }
    }

    private void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            this.getViewer().setExpandedElements(this.getElements(childMem).toArray());
        }
    }

    private List getElements(IMemento memento) {
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < elementMem.length) {
            IMemento[] labelMem = elementMem[i].getChildren(TAG_LABEL);
            Object[] children = this.getContentProvider().getElements(this.getViewer().getInput());
            Object e = null;
            int j = labelMem.length - 1;
            while (j >= 0) {
                e = this.findElement(children, labelMem[j].getString(TAG_LABEL));
                if (e == null) break;
                children = this.getContentProvider().getChildren(e);
                --j;
            }
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private Object findElement(Object[] list, String label) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (this.getLabelProvider().getColumnText(list[i], 0).equals(label)) {
                return list[i];
            }
            ++i;
        }
        return null;
    }
}

