/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private static final Log log;
    private HttpMethod method;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.ConnectMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ConnectMethod(HttpMethod method) {
        log.trace((Object)"enter ConnectMethod(HttpMethod)");
        this.method = method;
    }

    public String getName() {
        return NAME;
    }

    public int execute(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter ConnectMethod.execute(HttpState, HttpConnection)");
        int code = super.execute(state, conn);
        log.debug((Object)("CONNECT status code " + code));
        if (code >= 200 && code < 300) {
            conn.tunnelCreated();
            code = this.method.execute(state, conn);
        }
        return code;
    }

    protected void writeRequestHeaders(HttpState state, HttpConnection conn) throws HttpException, IOException {
        log.trace((Object)"enter ConnectMethod.writeRequestHeaders(HttpState, HttpConnection)");
        if (this.method instanceof HttpMethodBase) {
            ((HttpMethodBase)this.method).addRequestHeaders(state, conn);
        }
        conn.print(this.method.getRequestHeader("Host").toExternalForm());
        Header header = this.method.getRequestHeader("Proxy-Authorization");
        if (header == null) {
            header = this.getRequestHeader("Proxy-Authorization");
        }
        if (header != null) {
            conn.print(header.toExternalForm());
        }
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        int port = conn.getPort();
        if (port == -1) {
            port = conn.isSecure() ? 443 : 80;
        }
        String line = String.valueOf(this.getName()) + " " + conn.getHost() + ":" + port + " HTTP/1.1";
        conn.printLine(line);
    }
}

