/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpState {
    private HashMap credMap = new HashMap();
    private HashMap proxyCred = new HashMap();
    private ArrayList cookies = new ArrayList();
    private int cookiePolicy = 2;
    private HttpConnectionManager httpConnectionManager = new SimpleHttpConnectionManager();
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public HttpState() {
        this.cookiePolicy = CookiePolicy.getDefaultPolicy();
    }

    public synchronized void addCookie(Cookie cookie) {
        log.trace((Object)"enter HttpState.addCookie(Cookie)");
        if (cookie != null) {
            Iterator it = ((AbstractList)this.cookies).iterator();
            while (it.hasNext()) {
                Cookie tmp = (Cookie)it.next();
                if (!cookie.equals(tmp)) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired()) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] newcookies) {
        log.trace((Object)"enter HttpState.addCookies(Cookie[])");
        if (newcookies != null) {
            int i = 0;
            while (i < newcookies.length) {
                this.addCookie(newcookies[i]);
                ++i;
            }
        }
    }

    public synchronized Cookie[] getCookies() {
        log.trace((Object)"enter HttpState.getCookies()");
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized Cookie[] getCookies(String domain, int port, String path, boolean secure, Date now) {
        return this.getCookies(domain, port, path, secure);
    }

    public synchronized Cookie[] getCookies(String domain, int port, String path, boolean secure) {
        log.trace((Object)"enter HttpState.getCookies(String, int, String, boolean)");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        ArrayList<Cookie> list = new ArrayList<Cookie>(this.cookies.size());
        int i = 0;
        int m = this.cookies.size();
        while (i < m) {
            Cookie cookie = (Cookie)this.cookies.get(i);
            if (matcher.match(domain, port, path, secure, cookie)) {
                list.add(cookie);
            }
            ++i;
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public synchronized boolean purgeExpiredCookies() {
        log.trace((Object)"enter HttpState.purgeExpiredCookies()");
        return this.purgeExpiredCookies(new Date());
    }

    public synchronized boolean purgeExpiredCookies(Date date) {
        log.trace((Object)"enter HttpState.purgeExpiredCookies(Date)");
        boolean removed = false;
        Iterator it = ((AbstractList)this.cookies).iterator();
        while (it.hasNext()) {
            if (!((Cookie)it.next()).isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public int getCookiePolicy() {
        return this.cookiePolicy;
    }

    public void setCookiePolicy(int policy) {
        this.cookiePolicy = policy;
    }

    public synchronized void setCredentials(String realm, Credentials credentials) {
        log.trace((Object)"enter HttpState.setCredentials(String, Credentials)");
        this.credMap.put(realm, credentials);
    }

    public synchronized Credentials getCredentials(String realm) {
        log.trace((Object)"enter HttpState.getCredentials(String)");
        Credentials creds = (Credentials)this.credMap.get(realm);
        if (creds == null) {
            creds = (Credentials)this.credMap.get(null);
        }
        return creds;
    }

    public synchronized void setProxyCredentials(String realm, Credentials credentials) {
        log.trace((Object)"enter HttpState.setProxyCredentials(String, credentials)");
        this.proxyCred.put(realm, credentials);
    }

    public synchronized Credentials getProxyCredentials(String realm) {
        log.trace((Object)"enter HttpState.getProxyCredentials(String)");
        Credentials creds = (Credentials)this.proxyCred.get(realm);
        if (creds == null) {
            creds = (Credentials)this.proxyCred.get(null);
        }
        return creds;
    }

    public synchronized String toString() {
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("[");
        sbResult.append(HttpState.getProxyCredentialsStringRepresentation(this.proxyCred));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCredentialsStringRepresentation(this.proxyCred));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCookiesStringRepresentation(this.cookies));
        sbResult.append("]");
        String strResult = sbResult.toString();
        return strResult;
    }

    private static StringBuffer getProxyCredentialsStringRepresentation(Map proxyCredMap) {
        StringBuffer sbResult = new StringBuffer();
        Iterator iter = proxyCredMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Credentials cred = (Credentials)proxyCredMap.get(key);
            if (sbResult.length() > 0) {
                sbResult.append(", ");
            }
            sbResult.append(key);
            sbResult.append("#");
            sbResult.append(cred.toString());
        }
        return sbResult;
    }

    private static StringBuffer getCredentialsStringRepresentation(Map credMap) {
        StringBuffer sbResult = new StringBuffer();
        Iterator iter = credMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Credentials cred = (Credentials)credMap.get(key);
            if (sbResult.length() > 0) {
                sbResult.append(", ");
            }
            sbResult.append(key);
            sbResult.append("#");
            sbResult.append(cred.toString());
        }
        return sbResult;
    }

    private static StringBuffer getCookiesStringRepresentation(List cookies) {
        StringBuffer sbResult = new StringBuffer();
        Iterator iter = cookies.iterator();
        while (iter.hasNext()) {
            Cookie ck = (Cookie)iter.next();
            if (sbResult.length() > 0) {
                sbResult.append("#");
            }
            sbResult.append(ck.toExternalForm());
        }
        return sbResult;
    }

    public synchronized HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public synchronized void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }
}

