package monalipse.actions;

import java.net.URL;

import monalipse.bookmark.BookmarkManager;
import monalipse.bookmark.IBookmarkTreeNode;
import monalipse.server.IBBSReference;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BookmarkAction extends Action
{
	private String title;
	private URL url;

	public BookmarkAction()
	{
		super(BookmarkAction.class.getName());
	}
	
	public void run()
	{
		if(title != null && url != null && isEnabled())
		{
			IBookmarkTreeNode bookmark = BookmarkManager.getBookmarks();
			IBookmarkTreeNode exist = bookmark.findItem(url);
			if(exist == null)
			{
				bookmark.createLink(title, url, bookmark.hasChildren() ? IBookmarkTreeNode.LOCATION_ON : IBookmarkTreeNode.LOCATION_AFTER);
			}
			else
			{
				while(exist != null)
				{
					exist.remove();
					exist = bookmark.findItem(url);
				}
			}
			BookmarkManager.setBookmarks(bookmark);
		}
	}
	
	public void updateState(String title, URL url, boolean enabled)
	{
		this.title = title;
		this.url = url;
		if(!enabled || BookmarkManager.getBookmarks().findItem(url) == null)
		{
			setText("Add Bookmark");
			setToolTipText("Add Bookmark");
		}
		else
		{
			setText("Remove Bookmark");
			setToolTipText("Remove Bookmark");
		}
		setEnabled(enabled);
	}
	
	public IBBSReference updateState(ISelection selection)
	{
		if(selection instanceof IStructuredSelection)
		{
			Object first = ((IStructuredSelection)selection).getFirstElement();
			if(first instanceof IBBSReference)
			{
				IBBSReference ref = (IBBSReference)first;
				updateState(ref.getName(), ref.getURL(), true);
				return ref;
			}
		}
		
		updateState(null, null, false);
		return null;
	}

}
