/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import monalipse.editors.ThreadEditorInputFactory;
import monalipse.server.IThreadContentProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class ThreadEditorInput
implements IEditorInput,
IPersistableElement,
IAdaptable {
    private String url;
    private String title;
    private String tooltip;
    private boolean prefetch;

    public ThreadEditorInput(String url, String title, String tooltip) {
        this.url = url;
        this.title = title.trim();
        this.tooltip = tooltip;
    }

    public ThreadEditorInput(IThreadContentProvider thread) {
        this.url = thread.getURL().toExternalForm();
        this.title = thread.getName().trim();
        this.tooltip = String.valueOf(thread.getName()) + "\n" + this.url;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadEditorInput) {
            ThreadEditorInput ei = (ThreadEditorInput)obj;
            return ei.url.equals(this.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    public String getURL() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return ThreadEditorInputFactory.getFactoryId();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(".2chdat");
    }

    public String getName() {
        return this.title;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public void saveState(IMemento memento) {
        ThreadEditorInputFactory.saveState(memento, this);
    }
}

