/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Part {
    private static final Log log;
    static String boundary;
    static byte[] boundary_bytes;
    static String CRLF;
    static byte[] CRLF_bytes;
    static String extra;
    static byte[] extra_bytes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.methods.multipart.Part");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        boundary = "----------------314159265358979323846";
        boundary_bytes = HttpConstants.getBytes(boundary);
        CRLF = "\r\n";
        CRLF_bytes = HttpConstants.getBytes(CRLF);
        extra = "--";
        extra_bytes = HttpConstants.getBytes(extra);
    }

    public static String getBoundary() {
        return boundary;
    }

    public static void sendLastBoundary(OutputStream out) throws IOException {
        log.trace((Object)"enter sendLastBoundary(OutputStream out)");
        out.write(extra_bytes);
        out.write(boundary_bytes);
        out.write(extra_bytes);
        out.write(CRLF_bytes);
    }

    public static int lengthOfLastBoundary() throws IOException {
        log.trace((Object)"enter lengthOfLastBoundary()");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Part.sendLastBoundary(out);
        return out.size();
    }

    public abstract String getName();

    protected void sendStart(OutputStream out) throws IOException {
        log.trace((Object)"enter sendStart(OutputStream out)");
        out.write(extra_bytes);
        out.write(boundary_bytes);
        out.write(CRLF_bytes);
    }

    protected int lengthOfStart() throws IOException {
        log.trace((Object)"enter lengthOfStart()");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.sendStart(out);
        return out.size();
    }

    protected void sendHeader(OutputStream out) throws IOException {
        log.trace((Object)"enter sendHeader(OutputStream out)");
        String content_dispos = "Content-Disposition: form-data; name=\"" + this.getName() + "\"";
        out.write(HttpConstants.getBytes(content_dispos));
    }

    protected int lengthOfHeader() throws IOException {
        log.trace((Object)"enter lengthOfHeader()");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.sendHeader(out);
        return out.size();
    }

    protected void sendEndOfHeader(OutputStream out) throws IOException {
        log.trace((Object)"enter sendEndOfHeader(OutputStream out)");
        out.write(CRLF_bytes);
        out.write(CRLF_bytes);
    }

    protected int lengthOfEndOfHeader() throws IOException {
        log.trace((Object)"enter lengthOfEndOfHeader()");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.sendEndOfHeader(out);
        return out.size();
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected abstract long lengthOfData() throws IOException;

    protected void sendEnd(OutputStream out) throws IOException {
        log.trace((Object)"enter sendEnd(OutputStream out)");
        out.write(CRLF_bytes);
    }

    protected int lengthOfEnd() throws IOException {
        log.trace((Object)"enter lengthOfEnd()");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.sendEnd(out);
        return out.size();
    }

    public final void send(OutputStream out) throws IOException {
        log.trace((Object)"enter send(OutputStream out)");
        this.sendStart(out);
        this.sendHeader(out);
        this.sendEndOfHeader(out);
        this.sendData(out);
        this.sendEnd(out);
    }

    public final long length() throws IOException {
        log.trace((Object)"enter length()");
        return (long)(this.lengthOfStart() + this.lengthOfHeader() + this.lengthOfEndOfHeader()) + this.lengthOfData() + (long)this.lengthOfEnd();
    }

    public String toString() {
        return this.getName();
    }
}

