package monalipse.preferences;

import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadViewerEditor;
import monalipse.widgets.ColoredText;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;

public class AppearancePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{
	private ThreadViewerEditor.ThreadViewerAttributes attributes;
	private ColoredText text;

	public AppearancePreferencePage()
	{
		super(GRID);
		setPreferenceStore(MonalipsePlugin.getDefault().getPreferenceStore());
		setDescription("Monalipse.Appearance Preferences");
	}

	public void createFieldEditors()
	{
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_BODY_COLOR, WorkbenchMessages.getString("Preference.threadBodyColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_LINK_COLOR, WorkbenchMessages.getString("Preference.threadLinkColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_LINK_CLICKED_COLOR, WorkbenchMessages.getString("Preference.threadLinkClickedColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_MARKING_COLOR, WorkbenchMessages.getString("Preference.threadMarkingColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_NAME_COLOR, WorkbenchMessages.getString("Preference.threadNameColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_MAIL_COLOR, WorkbenchMessages.getString("Preference.threadMailColor"), getFieldEditorParent()));
		addField(new ColorFieldEditor(ThreadViewerEditor.PREF_BACKGROUND_COLOR, WorkbenchMessages.getString("Preference.threadBackgroundColor"), getFieldEditorParent()));
		addField(new FontFieldEditor(ThreadViewerEditor.PREF_NORMAL_FONT, WorkbenchMessages.getString("Preference.threadFont"), getFieldEditorParent()));
		addField(new IntegerFieldEditor(ThreadViewerEditor.PREF_LINE_HEIGHT, WorkbenchMessages.getString("Preference.threadLineHeight"), getFieldEditorParent()));
		
//		ColoredText text = new ColoredText(getFieldEditorParent(), SWT.BORDER | SWT.SMOOTH);
//		GridData grid = new GridData(GridData.FILL_BOTH);
//		grid.horizontalSpan = 3;
//		text.setLayoutData(grid);
//		attributes = new ThreadViewerEditor.ThreadViewerAttributes(getFieldEditorParent().getShell().getDisplay());
//		text.setAttributes(attributes);
//		text.setBackgroundAttribute(ThreadViewerEditor.ThreadViewerAttributes.COLOR_BACKGROUND);
//		ColoredText.Line line = new ColoredText.Line(0);
//		line.addLineFragment(new ColoredText.LineFragment("hoge", ThreadViewerEditor.ThreadViewerAttributes.COLOR_BODY, ThreadViewerEditor.ThreadViewerAttributes.FONT_NORMAL, false));
//		text.addLine(line);
	}
	
	public void dispose()
	{
		if(attributes != null)
			attributes.dispose();
		attributes = null;
	}

	public void init(IWorkbench workbench)
	{
	}
}
