/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.actions.BookmarkAction;
import monalipse.bookmark.BookmarkManager;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.IThreadContentProvider;
import monalipse.utils.CancelableRunner;
import monalipse.views.AbstractTableTreeView;
import monalipse.views.ComboTextOperationTarget;
import monalipse.views.ViewUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ThreadListView
extends AbstractTableTreeView
implements ISelectionListener,
IResourceChangeListener,
SelectionListener {
    public static final String ID_THREAD_LIST;
    private static final Logger logger;
    private static final String TAG_INPUT = "input";
    private static final String TAG_URL = "url";
    private static final String TAG_TITLE = "title";
    private TableTreeViewer viewer;
    private ThreadListContentProvider provider;
    private CancelableRunner cancelable;
    private IAction reloadAction;
    private IAction abortAction;
    private IAction doubleClickAction;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction deleteAction;
    private IAction selectAllAction;
    private BookmarkAction bookmarkAction;
    private Combo searchCombo;
    private String constraint;
    private FocusListener focusListener;
    private IBBSBoard inputQueue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_THREAD_LIST = clazz.getName();
        logger = MonalipsePlugin.getLogger();
    }

    public ThreadListView() {
        logger.finest("<init>");
    }

    protected ITreeContentProvider getContentProvider() {
        return this.provider;
    }

    protected ITableLabelProvider getLabelProvider() {
        return this.provider;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected TableTreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        logger.finest("begin");
        this.viewer = new TableTreeViewer(parent, 66308);
        this.provider = new ThreadListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.makeColumns();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initializeTextActions();
        this.updateSelectionDependentActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewer.getTableTree().addSelectionListener((SelectionListener)this);
        this.hookDragAndDrop();
        this.partCreated();
        logger.finest("done");
        this.focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                logger.finest("begin");
                ThreadListView.this.updateSelectionDependentActions();
                ThreadListView.this.ensureSearchComboInit();
                logger.finest("done");
            }
        };
        this.viewer.getControl().addFocusListener(this.focusListener);
        this.viewer.getTableTree().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ThreadListView.this.reloadAction.run();
                }
            }
        });
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer.getInput() instanceof IBBSBoard) {
            Object[] changed;
            logger.finest("begin");
            IBBSBoard board = (IBBSBoard)this.viewer.getInput();
            if (board.threadListChanged(event)) {
                logger.finest("threadListChanged");
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ThreadListView.this.refreshList();
                        if (ThreadListView.this.viewer.getVisibleExpandedElements().length == 0) {
                            ThreadListView.this.expandFirstFragment();
                        }
                    }
                });
            }
            if ((changed = board.getChangedItems(event)) != null) {
                logger.finest("update");
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ThreadListView.this.viewer.update(changed, null);
                    }
                });
            }
            if (BookmarkManager.bookmarkChanged(event)) {
                logger.finest("bookmarkChanged");
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ThreadListView.this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf((IBBSBoard)ThreadListView.this.viewer.getInput()));
                        ThreadListView.this.viewer.refresh(true);
                    }
                });
            }
            logger.finest("done");
        }
    }

    private void refreshList() {
        if (this.provider != null) {
            logger.finest("begin");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            logger.finest("reset input");
            this.viewer.setInput(this.viewer.getInput());
            this.restoreState((IMemento)memento);
            logger.finest("done");
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IBBSBoard board;
        Object first;
        if (!this.viewer.getTableTree().isDisposed() && part != this && selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IBBSReference && (board = BBSServerManager.getBoardOf(((IBBSReference)first).getURL())) != null) {
            this.selectionChanged(board);
        }
    }

    private void selectionChanged(IBBSBoard board) {
        if (this.inputQueue == null && this.viewer.getInput() == board) {
            return;
        }
        if (this.inputQueue != null && this.inputQueue == board) {
            return;
        }
        this.inputQueue = board;
        new Thread(new Runnable(){

            public void run() {
                IBBSBoard board;
                ThreadListView.this.getSite().getShell().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                    }
                });
                IEditorPart editor = ThreadListView.this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
                if (editor instanceof ThreadViewerEditor) {
                    ((ThreadViewerEditor)editor).getCancelable().runAndJoin(editor, new CancelableRunner.ICancelableRunnableWithProgress(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        }
                    });
                    ((ThreadViewerEditor)editor).getCancelable().runAndJoin(editor, new CancelableRunner.ICancelableRunnableWithProgress(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        }
                    });
                }
                if ((board = ThreadListView.this.inputQueue) != null) {
                    board.ensureCacheLoaded();
                }
                ThreadListView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (ThreadListView.access$8(6.access$0(this.this$1)) != null) {
                            IBBSBoard board = ThreadListView.access$8(6.access$0(this.this$1));
                            ThreadListView.access$9(6.access$0(this.this$1), null);
                            ThreadListView.access$10(6.access$0(this.this$1), board);
                        }
                    }
                });
            }

            static /* synthetic */ ThreadListView access$0(6 var0) {
                return var0.ThreadListView.this;
            }
        }).start();
    }

    private void setInput(IBBSBoard board) {
        logger.finest("begin");
        this.setTitle(board.getName());
        this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf(board));
        if (this.viewer.getInput() == null || !this.viewer.getInput().equals(board)) {
            logger.finest("folder changed");
            if (this.viewer.getInput() instanceof IBBSBoard) {
                this.saveSearchWord((IResource)((IBBSBoard)this.viewer.getInput()).getLogFolder());
            }
            this.constraint = "";
            this.viewer.setInput((Object)board);
            this.restoreSearchWord((IResource)board.getLogFolder());
            if (this.provider.getElements(this.viewer.getInput()).length == 0) {
                logger.finest("empty thread list");
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ThreadListView.this.reloadAction.run();
                    }
                });
            } else {
                this.expandFirstFragment();
            }
        }
        logger.finest("done");
    }

    private void expandFirstFragment() {
        if (this.provider.hasChildren(this.viewer.getInput())) {
            logger.finest("begin");
            Object[] fragments = this.provider.getElements(this.viewer.getInput());
            if (fragments.length > 0 && this.provider.hasChildren(fragments[0])) {
                logger.finest("set expansion");
                this.viewer.setExpandedElements(new Object[]{fragments[0]});
            }
            logger.finest("done");
        }
    }

    public void widgetSelected(SelectionEvent e) {
        logger.finest("begin");
        IBBSReference ref = this.bookmarkAction.updateState(this.viewer.getSelection());
        if (ref instanceof IThreadContentProvider) {
            ThreadViewerEditor.activateEditor(this.getSite(), (IThreadContentProvider)ref);
        }
        logger.finest("done");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void saveSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                logger.finest("begin");
                StringBuffer buf = new StringBuffer();
                String[] keys = this.searchCombo.getItems();
                int i = 0;
                while (i < keys.length && i < 10) {
                    buf.append(URLEncoder.encode(keys[i], "UTF-8")).append(" ");
                    ++i;
                }
                logger.finest("save search word: " + buf.toString());
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"), buf.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void restoreSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                this.searchCombo.removeAll();
                this.searchCombo.add("");
                String keys = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"));
                if (keys != null) {
                    logger.finest("restore search word: " + keys);
                    StringTokenizer tk = new StringTokenizer(keys);
                    while (tk.hasMoreTokens()) {
                        this.searchCombo.add(URLDecoder.decode(tk.nextToken(), "UTF-8"));
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.getLogger().finest("begin");
        if (this.getViewer() != null) {
            this.saveInputState(memento);
        }
        this.getLogger().finest("done");
    }

    private void saveInputState(IMemento memento) {
        IMemento elementMem = memento.createChild(TAG_INPUT);
        if (this.viewer.getInput() instanceof IBBSBoard) {
            elementMem.putString(TAG_URL, ((IBBSBoard)this.viewer.getInput()).getURL().toExternalForm());
        }
        elementMem.putString(TAG_TITLE, this.getTitle());
        if (this.viewer.getInput() instanceof IBBSBoard) {
            this.saveSearchWord((IResource)((IBBSBoard)this.viewer.getInput()).getLogFolder());
        }
    }

    protected void restoreState(IMemento memento) {
        this.restoreInputState(memento);
        super.restoreState(memento);
    }

    private void restoreInputState(IMemento memento) {
        IMemento elementMem = memento.getChild(TAG_INPUT);
        if (elementMem != null) {
            String title;
            String url = elementMem.getString(TAG_URL);
            logger.finest(url);
            if (url != null) {
                try {
                    IBBSBoard board = BBSServerManager.getBoardOf(new URL(url));
                    if (board != null) {
                        this.viewer.setInput((Object)board);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((title = elementMem.getString(TAG_TITLE)) != null) {
                this.setTitle(title);
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ThreadListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatuBar(bars.getStatusLineManager());
    }

    private void fillLocalStatuBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.bookmarkAction.updateState(this.viewer.getSelection());
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.bookmarkAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.add((IContributionItem)new ControlContribution(String.valueOf(clazz.getName()) + ".constrain"){

            protected Control createControl(Composite parent) {
                ViewUtils.ComboInfo info = ViewUtils.createCombo(parent, 2052);
                ThreadListView.this.searchCombo = info.combo;
                ThreadListView.this.searchCombo.addFocusListener(ThreadListView.this.focusListener);
                ThreadListView.this.searchCombo.setToolTipText("Search");
                ThreadListView.this.searchCombo.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    private void selected(SelectionEvent e) {
                        String text = ThreadListView.access$13(13.access$0(this.this$1)).getText();
                        if (text.length() > 0) {
                            if (Arrays.asList(ThreadListView.access$13(13.access$0(this.this$1)).getItems()).contains(text)) {
                                ThreadListView.access$13(13.access$0(this.this$1)).remove(text);
                            }
                            ThreadListView.access$13(13.access$0(this.this$1)).add(text, 1);
                        }
                        ThreadListView.access$15(13.access$0(this.this$1), text);
                        ThreadListView.access$5(13.access$0(this.this$1));
                        ThreadListView.access$13(13.access$0(this.this$1)).setText(text);
                        if (ThreadListView.access$1(13.access$0(this.this$1)).getVisibleExpandedElements().length == 0) {
                            ThreadListView.access$6(13.access$0(this.this$1));
                        }
                    }
                });
                return info.control;
            }

            static /* synthetic */ ThreadListView access$0(13 var0) {
                return var0.ThreadListView.this;
            }
        });
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
    }

    private void ensureSearchComboInit() {
        if (this.searchCombo.getItemCount() == 0) {
            this.searchCombo.add("");
            if (this.viewer.getInput() instanceof IBBSBoard) {
                this.restoreSearchWord((IResource)((IBBSBoard)this.viewer.getInput()).getLogFolder());
            }
        }
    }

    private void makeColumns() {
        TableTree table = this.viewer.getTableTree();
        table.getTable().setHeaderVisible(true);
        table.getTable().setLinesVisible(true);
        TableColumn col = new TableColumn(table.getTable(), 16384);
        col.setText("Rank");
        col.setWidth(80);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Title");
        col.setWidth(400);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Response");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Cache");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Read");
        col.setWidth(50);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.run(ThreadListView.this.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this){
                    final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        if (ThreadListView.access$1(15.access$0(this.this$1)).getInput() instanceof IBBSBoard) {
                            ThreadListView.access$2().finest("refresh");
                            ((IBBSBoard)ThreadListView.access$1(15.access$0(this.this$1)).getInput()).updateThreadList();
                        }
                    }
                });
            }

            static /* synthetic */ ThreadListView access$0(15 var0) {
                return var0.ThreadListView.this;
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload thread list");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ThreadListView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object first = ((IStructuredSelection)selection).getFirstElement();
                    if (first instanceof IThreadContentProvider) {
                        logger.finest("begin");
                        IThreadContentProvider thread = (IThreadContentProvider)first;
                        IWorkbenchPage page = ThreadListView.this.getSite().getPage().getWorkbenchWindow().getActivePage();
                        try {
                            IEditorPart part;
                            logger.finest("openEditor");
                            ThreadEditorInput tei = new ThreadEditorInput(thread);
                            tei.setPrefetch(true);
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = class$1 = Class.forName("monalipse.editors.ThreadViewerEditor");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((part = page.openEditor((IEditorInput)tei, clazz.getName())) instanceof ThreadViewerEditor) {
                                logger.finest("updateThread");
                                ((ThreadViewerEditor)part).updateThread(-1);
                            }
                            tei.setPrefetch(false);
                        }
                        catch (PartInitException ex) {
                            ex.printStackTrace();
                        }
                        logger.finest("done");
                    } else if (first != null) {
                        ThreadListView.this.viewer.setExpandedState(first, !ThreadListView.this.viewer.getExpandedState(first));
                    }
                }
            }
        };
        this.bookmarkAction = new BookmarkAction();
    }

    private IAction createAction(String id, final int action, String image) {
        Action act = new Action(WorkbenchMessages.getString((String)("Workbench." + id))){

            public void run() {
                ITextOperationTarget target = ThreadListView.this.getTextOperationTarget();
                if (target != null) {
                    target.doOperation(action);
                }
            }
        };
        if (image != null) {
            act.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)image));
            act.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_DISABLED")));
            act.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_HOVER")));
        }
        this.getViewSite().getActionBars().setGlobalActionHandler(id, (IAction)act);
        return act;
    }

    private void initializeTextActions() {
        this.cutAction = this.createAction("cut", 3, "IMG_CTOOL_CUT_EDIT");
        this.copyAction = this.createAction("copy", 4, "IMG_CTOOL_COPY_EDIT");
        this.pasteAction = this.createAction("paste", 5, "IMG_CTOOL_PASTE_EDIT");
        this.deleteAction = this.createAction("delete", 6, "IMG_CTOOL_DELETE_EDIT");
        this.selectAllAction = this.createAction("selectAll", 7, null);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ThreadListView.this.fillContextMenu(mgr);
            }
        });
    }

    private ITextOperationTarget getTextOperationTarget() {
        ComboTextOperationTarget target = null;
        if (this.searchCombo != null && this.searchCombo.isFocusControl()) {
            target = new ComboTextOperationTarget(this.searchCombo);
        }
        return target;
    }

    protected void updateSelectionDependentActions() {
        ITextOperationTarget target = this.getTextOperationTarget();
        this.cutAction.setEnabled(target != null && target.canDoOperation(3));
        this.copyAction.setEnabled(target != null && target.canDoOperation(4));
        this.pasteAction.setEnabled(target != null && target.canDoOperation(5));
        this.deleteAction.setEnabled(target != null && target.canDoOperation(6));
        this.selectAllAction.setEnabled(target != null && target.canDoOperation(7));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ThreadListView.this.doubleClickAction.run();
            }
        });
    }

    private void hookDragAndDrop() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ void access$9(ThreadListView threadListView, IBBSBoard iBBSBoard) {
        threadListView.inputQueue = iBBSBoard;
    }

    static /* synthetic */ void access$10(ThreadListView threadListView, IBBSBoard iBBSBoard) {
        threadListView.setInput(iBBSBoard);
    }

    static /* synthetic */ void access$15(ThreadListView threadListView, String string) {
        threadListView.constraint = string;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class ThreadListContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    ITableLabelProvider {
        private static final int THREAD_LIST_DIVIDE_SIZE = 50;
        static /* synthetic */ Class class$0;

        ThreadListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IBBSBoard) {
                IThreadContentProvider[] cps = ((IBBSBoard)inputElement).getThreadList(ThreadListView.this.constraint);
                Object[] fragments = new Fragment[(cps.length + 50 - 1) / 50];
                int i = 0;
                while (i < fragments.length) {
                    fragments[i] = new Fragment(cps, 50 * i);
                    ++i;
                }
                return fragments;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Fragment) {
                return ((Fragment)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Fragment) {
                return ThreadListView.this.viewer.getInput();
            }
            if (element instanceof IThreadContentProvider) {
                int index = ((IThreadContentProvider)element).getIndex() / 50;
                Object[] list = this.getElements(ThreadListView.this.viewer.getInput());
                if (index >= 0 && index < list.length) {
                    return list[index];
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Fragment || element instanceof IBBSBoard;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            if (element instanceof Fragment) {
                return ((Fragment)element).getText();
            }
            if (element instanceof IThreadContentProvider) {
                return ((IThreadContentProvider)element).getName();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IThreadContentProvider && columnIndex == 1 && element instanceof IBBSReference) {
                return MonalipsePlugin.getDefault().getLabelImageOf((IBBSReference)element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IThreadContentProvider) {
                IThreadContentProvider thread = (IThreadContentProvider)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(thread.getIndex() + 1);
                    }
                    case 1: {
                        return thread.getName();
                    }
                    case 2: {
                        return String.valueOf(thread.getResponseCountHint());
                    }
                    case 3: {
                        return String.valueOf(thread.getCachedCount());
                    }
                    case 4: {
                        return this.getPersistentCountProperty(thread, "read");
                    }
                }
            } else if (element instanceof Fragment && columnIndex == 0) {
                return ((Fragment)element).getText();
            }
            return "";
        }

        private String getPersistentCountProperty(IThreadContentProvider thread, String type) {
            try {
                String count;
                IFile iFile = thread.getLogFile();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((count = iFile.getPersistentProperty(new QualifiedName(clazz.getName(), type))) == null) {
                    count = "0";
                }
                return count;
            }
            catch (CoreException coreException) {
                return "0";
            }
        }

        private class Fragment {
            private IThreadContentProvider[] children;
            private int start;

            public Fragment(IThreadContentProvider[] children, int start) {
                this.children = children;
                this.start = start;
            }

            public IThreadContentProvider[] getChildren() {
                IThreadContentProvider[] ch = new IThreadContentProvider[Math.min(this.children.length - this.start, 50)];
                int i = 0;
                while (i < ch.length) {
                    ch[i] = this.children[this.start + i];
                    ++i;
                }
                return ch;
            }

            public String getText() {
                return String.valueOf(this.start + 1) + "..." + (this.start + 50);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Fragment) {
                    return ((Fragment)obj).start == this.start;
                }
                return false;
            }

            public int hashCode() {
                return this.start;
            }
        }
    }
}

