/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.threadpool;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MTQueue {
    private Log log;
    private LinkedList list;
    private long timeout;
    static /* synthetic */ Class class$0;

    public MTQueue() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.threadpool.MTQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.list = new LinkedList();
        this.timeout = 10000L;
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized void add(Object object) {
        this.list.add(object);
        this.notify();
    }

    public synchronized Object remove() {
        Object answer;
        while ((answer = this.removeNoWait()) == null) {
            try {
                this.wait(this.timeout);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Thread was interrupted: " + e), (Throwable)e);
                continue;
            }
            break;
        }
        return answer;
    }

    public synchronized Object remove(long timeout) {
        Object answer = this.removeNoWait();
        if (answer == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Thread was interrupted: " + e), (Throwable)e);
            }
            answer = this.removeNoWait();
        }
        return answer;
    }

    public synchronized Object removeNoWait() {
        if (!this.list.isEmpty()) {
            return this.list.removeFirst();
        }
        return null;
    }
}

