/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpException;

public class StatusLine {
    private final String statusLine;
    private final String httpVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public StatusLine(String statusLine) throws HttpException {
        this.statusLine = new String(statusLine);
        int length = statusLine.length();
        if (!statusLine.startsWith("HTTP/")) {
            throw new HttpException("Status-Line '" + statusLine + "' does not start with HTTP/");
        }
        int at = statusLine.indexOf(" ");
        if (at <= 0) {
            throw new HttpException("Unable to parse HTTP-Version from the status line: '" + statusLine + "'");
        }
        this.httpVersion = statusLine.substring(0, at).toUpperCase();
        while (statusLine.charAt(at) == ' ') {
            ++at;
        }
        int to = statusLine.indexOf(" ", at);
        if (to < 0) {
            to = length;
        }
        try {
            this.statusCode = Integer.parseInt(statusLine.substring(at, to));
        }
        catch (NumberFormatException e) {
            throw new HttpException("Unable to parse status code from status line: '" + statusLine + "'");
        }
        at = to + 1;
        try {
            this.reasonPhrase = at < length ? statusLine.substring(at).trim() : "";
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HttpException("Status text not specified: '" + statusLine + "'");
        }
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHttpVersion() {
        return this.httpVersion;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String toString() {
        return this.statusLine;
    }
}

