package monalipse.views;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

public class ComboTextOperationTarget implements ITextOperationTarget
{
	private Combo combo;

	public ComboTextOperationTarget(Combo combo)
	{
		this.combo = combo;
	}

	public boolean canDoOperation(int operation)
	{
		switch(operation)
		{
		case ITextOperationTarget.CUT:
		case ITextOperationTarget.COPY:
		case ITextOperationTarget.PASTE:
		case ITextOperationTarget.DELETE:
		case ITextOperationTarget.SELECT_ALL:
			return true;
		
		default:
			return false;
		}
	}

	public void doOperation(int operation)
	{
		Point sel = combo.getSelection();
		String text = combo.getText();
		String selected = text.substring(sel.x, sel.y);
		switch(operation)
		{
		case ITextOperationTarget.CUT:
			new Clipboard(combo.getShell().getDisplay()).setContents(new Object[]{selected}, new Transfer[]{TextTransfer.getInstance()});
			text = text.substring(0, sel.x) + text.substring(sel.y, text.length());
			combo.setText(text);
			break;

		case ITextOperationTarget.COPY:
			new Clipboard(combo.getShell().getDisplay()).setContents(new Object[]{selected}, new Transfer[]{TextTransfer.getInstance()});
			break;

		case ITextOperationTarget.PASTE:
			String paste = (String)new Clipboard(combo.getShell().getDisplay()).getContents(TextTransfer.getInstance());
			text = text.substring(0, sel.x) + paste + text.substring(sel.y, text.length());
			combo.setText(text);
			break;

		case ITextOperationTarget.DELETE:
			text = text.substring(0, sel.x) + text.substring(sel.y, text.length());
			combo.setText(text);
			break;

		case ITextOperationTarget.SELECT_ALL:
			combo.setSelection(new Point(0, combo.getText().length()));
			break;
		}
	}

}