/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebRequestSource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class UncheckedParameterHolder
extends ParameterHolder {
    private static final String[] NO_VALUES = new String[0];
    private final String _characterSet;
    private Hashtable _parameters = new Hashtable();
    private boolean _submitAsMime;

    UncheckedParameterHolder() {
        this._characterSet = "iso-8859-1";
    }

    UncheckedParameterHolder(WebRequestSource source) {
        this._characterSet = source.getCharacterSet();
        this._submitAsMime = source.isSubmitAsMime();
        String[] names = source.getParameterNames();
        int i = 0;
        while (i < names.length) {
            if (!source.isFileParameter(names[i])) {
                this._parameters.put(names[i], source.getParameterValues(names[i]));
            }
            ++i;
        }
    }

    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        this.setParameter(String.valueOf(imageButton.getName()) + ".x", Integer.toString(x));
        this.setParameter(String.valueOf(imageButton.getName()) + ".y", Integer.toString(y));
    }

    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
    }

    void recordParameters(ParameterProcessor processor) throws IOException {
        Enumeration e = this._parameters.keys();
        while (e.hasMoreElements()) {
            int i;
            String name = (String)e.nextElement();
            Object value = this._parameters.get(name);
            if (value instanceof String) {
                processor.addParameter(name, (String)value, this._characterSet);
                continue;
            }
            if (value instanceof String[]) {
                String[] values = (String[])value;
                i = 0;
                while (i < values.length) {
                    processor.addParameter(name, values[i], this._characterSet);
                    ++i;
                }
                continue;
            }
            if (!(value instanceof UploadFileSpec[])) continue;
            UploadFileSpec[] files = (UploadFileSpec[])value;
            i = 0;
            while (i < files.length) {
                processor.addFile(name, files[i]);
                ++i;
            }
        }
    }

    String[] getParameterNames() {
        return this._parameters.keySet().toArray(new String[this._parameters.size()]);
    }

    String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? null : values[0];
    }

    String[] getParameterValues(String name) {
        Object result = this._parameters.get(name);
        if (result instanceof String) {
            return new String[]{(String)result};
        }
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result instanceof UploadFileSpec) {
            return new String[]{result.toString()};
        }
        return NO_VALUES;
    }

    void removeParameter(String name) {
        this._parameters.remove(name);
    }

    void setParameter(String name, String value) {
        this._parameters.put(name, value);
    }

    void setParameter(String name, String[] values) {
        this._parameters.put(name, values);
    }

    void setParameter(String name, UploadFileSpec[] files) {
        this._parameters.put(name, files);
    }

    boolean isFileParameter(String name) {
        return true;
    }

    boolean isSubmitAsMime() {
        return this._submitAsMime;
    }

    void setSubmitAsMime(boolean mimeEncoded) {
        this._submitAsMime = mimeEncoded;
    }
}

