/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.AuthorizationRequiredException;
import com.meterware.httpunit.Base64;
import com.meterware.httpunit.FrameHolder;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.RedirectWebRequest;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.SAXException;

public abstract class WebClient
implements FrameHolder {
    private Hashtable _cookies = new Hashtable();
    private Hashtable _frameContents = new Hashtable();
    private Hashtable _subFrames = new Hashtable();
    private HeaderDictionary _headers = new HeaderDictionary();
    private boolean _exceptionsThrownOnErrorStatus = HttpUnitOptions.getExceptionsThrownOnErrorStatus();
    private List _clientListeners = new ArrayList();

    public WebResponse getResponse(String urlString) throws MalformedURLException, IOException, SAXException {
        return this.getResponse(new GetMethodWebRequest(urlString));
    }

    public WebResponse sendRequest(WebRequest request) throws MalformedURLException, IOException, SAXException {
        return this.getResponse(request);
    }

    public WebResponse getResponse(WebRequest request) throws MalformedURLException, IOException, SAXException {
        if (request.getURLString().startsWith("about:")) {
            return WebResponse.BLANK_RESPONSE;
        }
        this.tellListeners(request);
        WebResponse response = this.newResponse(request);
        this.tellListeners(response);
        this.updateClient(response);
        return this.getFrameContents(request.getTarget());
    }

    private void tellListeners(WebRequest request) {
        ArrayList listeners;
        List list = this._clientListeners;
        synchronized (list) {
            listeners = new ArrayList(this._clientListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebClientListener)i.next()).requestSent(this, request);
        }
    }

    private void tellListeners(WebResponse response) {
        ArrayList listeners;
        List list = this._clientListeners;
        synchronized (list) {
            listeners = new ArrayList(this._clientListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebClientListener)i.next()).responseReceived(this, response);
        }
    }

    public void clearContents() {
        this._frameContents = new Hashtable();
        this._cookies = new Hashtable();
        this._headers = new HeaderDictionary();
    }

    public String[] getFrameNames() {
        Vector names = new Vector();
        Enumeration e = this._frameContents.keys();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    public WebResponse getFrameContents(String frameName) {
        WebResponse response = (WebResponse)this._frameContents.get(frameName);
        if (response == null) {
            throw new NoSuchFrameException(frameName);
        }
        return response;
    }

    public void addCookie(String name, String value) {
        this._cookies.put(name, value);
    }

    public String[] getCookieNames() {
        String[] names = new String[this._cookies.size()];
        int i = 0;
        Enumeration e = this._cookies.keys();
        while (e.hasMoreElements()) {
            names[i++] = (String)e.nextElement();
        }
        return names;
    }

    public String getCookieValue(String name) {
        return (String)this._cookies.get(name);
    }

    public void setUserAgent(String userAgent) {
        this.setHeaderField("User-Agent", userAgent);
    }

    public String getUserAgent() {
        return this.getHeaderField("User-Agent");
    }

    public void setAuthorization(String userName, String password) {
        this.setHeaderField("Authorization", "Basic " + Base64.encode(String.valueOf(userName) + ':' + password));
    }

    public void setHeaderField(String fieldName, String fieldValue) {
        this._headers.put(fieldName, fieldValue);
    }

    public String getHeaderField(String fieldName) {
        return (String)this._headers.get(fieldName);
    }

    public void setExceptionsThrownOnErrorStatus(boolean throwExceptions) {
        this._exceptionsThrownOnErrorStatus = throwExceptions;
    }

    public boolean getExceptionsThrownOnErrorStatus() {
        return this._exceptionsThrownOnErrorStatus;
    }

    public void addClientListener(WebClientListener listener) {
        List list = this._clientListeners;
        synchronized (list) {
            if (listener != null && !this._clientListeners.contains(listener)) {
                this._clientListeners.add(listener);
            }
        }
    }

    public void removeClientListener(WebClientListener listener) {
        List list = this._clientListeners;
        synchronized (list) {
            this._clientListeners.remove(listener);
        }
    }

    protected WebClient() {
        if (HttpUnitOptions.isAcceptGzip()) {
            this.setHeaderField("Accept-Encoding", "gzip");
        }
    }

    protected abstract WebResponse newResponse(WebRequest var1) throws MalformedURLException, IOException;

    protected final void writeMessageBody(WebRequest request, OutputStream stream) throws IOException {
        request.writeMessageBody(stream);
    }

    protected String getCookieHeaderField() {
        String[] names = this.getCookieNames();
        if (names.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < names.length) {
            if (i != 0) {
                sb.append("; ");
            }
            String name = names[i];
            sb.append(name).append('=').append(this.getCookieValue(name));
            ++i;
        }
        return sb.toString();
    }

    protected Dictionary getHeaderFields() {
        Hashtable result = (Hashtable)this._headers.clone();
        if (this.getCookieHeaderField() != null) {
            result.put("Cookie", this.getCookieHeaderField());
        }
        return result;
    }

    protected final void updateClient(WebResponse response) throws MalformedURLException, IOException, SAXException {
        this.updateCookies(response);
        this.validateHeaders(response);
        if (HttpUnitOptions.getAutoRefresh() && response.getRefreshRequest() != null) {
            this.getResponse(response.getRefreshRequest());
        } else if (this.shouldFollowRedirect(response)) {
            this.delay(HttpUnitOptions.getRedirectDelay());
            this.getResponse(new RedirectWebRequest(response));
        } else {
            this.updateFrames(response);
        }
    }

    private boolean shouldFollowRedirect(WebResponse response) {
        return HttpUnitOptions.getAutoRedirect() && response.getResponseCode() >= 301 && response.getResponseCode() <= 302 && response.getHeaderField("Location") != null;
    }

    private void validateHeaders(WebResponse response) throws HttpException, IOException {
        if (response.getHeaderField("WWW-Authenticate") != null) {
            throw new AuthorizationRequiredException(response.getHeaderField("WWW-Authenticate"));
        }
        if (this.getExceptionsThrownOnErrorStatus()) {
            if (response.getResponseCode() == 500) {
                throw new HttpInternalErrorException(response.getURL());
            }
            if (response.getResponseCode() == 404) {
                throw new HttpNotFoundException(response.getURL());
            }
            if (response.getResponseCode() >= 400) {
                throw new HttpException(response.getResponseCode(), response.getResponseMessage(), response.getURL());
            }
        }
    }

    private void updateCookies(WebResponse response) {
        String[] names = response.getNewCookieNames();
        int i = 0;
        while (i < names.length) {
            this.addCookie(names[i], response.getNewCookieValue(names[i]));
            ++i;
        }
    }

    private void delay(int numMilliseconds) {
        if (numMilliseconds == 0) {
            return;
        }
        try {
            Thread.sleep(numMilliseconds);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void updateFrames(WebResponse response) throws MalformedURLException, IOException, SAXException {
        this.removeSubFrames(response.getTarget());
        response.setFrameHolder(this);
        this._frameContents.put(response.getTarget(), response);
        if (response.isHTML()) {
            this.createSubFrames(response.getTarget(), response.getFrameNames());
            WebRequest[] requests = response.getFrameRequests();
            int i = 0;
            while (i < requests.length) {
                this.getResponse(requests[i]);
                ++i;
            }
        }
    }

    private void createSubFrames(String targetName, String[] frameNames) {
        this._subFrames.put(targetName, frameNames);
        int i = 0;
        while (i < frameNames.length) {
            this._frameContents.put(frameNames[i], WebResponse.BLANK_RESPONSE);
            ++i;
        }
    }

    private void removeSubFrames(String targetName) {
        String[] names = (String[])this._subFrames.get(targetName);
        if (names == null) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            this.removeSubFrames(names[i]);
            this._frameContents.remove(names[i]);
            this._subFrames.remove(names[i]);
            ++i;
        }
    }

    public static class HeaderDictionary
    extends Hashtable {
        public void addEntries(Dictionary source) {
            Enumeration e = source.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.put(key, source.get(key));
            }
        }

        public Object get(Object fieldName) {
            return (String)super.get(this.matchPreviousFieldName(fieldName.toString()));
        }

        public Object put(Object fieldName, Object fieldValue) {
            fieldName = this.matchPreviousFieldName(fieldName.toString());
            Object oldValue = super.get(fieldName);
            if (fieldValue == null) {
                this.remove(fieldName);
            } else {
                super.put(fieldName, fieldValue);
            }
            return oldValue;
        }

        private String matchPreviousFieldName(String fieldName) {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.equalsIgnoreCase(fieldName)) continue;
                return key;
            }
            return fieldName;
        }
    }
}

