/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.IllegalLinkParametersRequest;
import com.meterware.httpunit.LinkParameter;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebRequestSource;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class WebLink
extends WebRequestSource {
    private static final String[] NO_VALUES = new String[0];
    private Map _presetParameterMap;
    private ArrayList _presetParameterList;

    public String getURLString() {
        String href = NodeUtils.getNodeAttribute(this.getNode(), "href");
        int hashIndex = href.indexOf(35);
        if (hashIndex < 0) {
            return href;
        }
        return href.substring(0, hashIndex);
    }

    public String asText() {
        if (this.getNode().getNodeName().equals("area")) {
            return NodeUtils.getNodeAttribute(this.getNode(), "alt");
        }
        if (!this.getNode().hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this.getNode().getChildNodes());
    }

    public WebRequest getRequest() {
        return new GetMethodWebRequest(this);
    }

    public String[] getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.getPresetParameterMap().keySet());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.getPresetParameterMap().get(name);
        return values == null ? NO_VALUES : values;
    }

    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        throw new IllegalLinkParametersRequest();
    }

    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
    }

    void recordParameters(ParameterProcessor processor) throws IOException {
        Iterator i = ((AbstractList)this.getPresetParameterList()).iterator();
        while (i.hasNext()) {
            LinkParameter o = (LinkParameter)i.next();
            processor.addParameter(o.getName(), o.getValue(), this.getCharacterSet());
        }
    }

    void removeParameter(String name) {
        throw new IllegalLinkParametersRequest();
    }

    void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    void setParameter(String name, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("May not supply a null argument array to setParameter()");
        }
        if (!this.getPresetParameterMap().containsKey(name)) {
            throw new IllegalLinkParametersRequest();
        }
        if (!this.equals(this.getParameterValues(name), values)) {
            throw new IllegalLinkParametersRequest();
        }
    }

    private boolean equals(String[] left, String[] right) {
        if (left.length != right.length) {
            return false;
        }
        List<String> rightValues = Arrays.asList(right);
        int i = 0;
        while (i < left.length) {
            if (!rightValues.contains(left[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void setParameter(String name, UploadFileSpec[] files) {
        throw new IllegalLinkParametersRequest();
    }

    boolean isFileParameter(String name) {
        return false;
    }

    boolean isSubmitAsMime() {
        return false;
    }

    void setSubmitAsMime(boolean mimeEncoded) {
        throw new IllegalStateException("May not change the encoding for a validated request created from a link");
    }

    WebLink(URL baseURL, String parentTarget, Node node) {
        super(node, baseURL, NodeUtils.getNodeAttribute(node, "href"), parentTarget);
    }

    private Map getPresetParameterMap() {
        if (this._presetParameterMap == null) {
            this.loadPresetParameters();
        }
        return this._presetParameterMap;
    }

    private ArrayList getPresetParameterList() {
        if (this._presetParameterList == null) {
            this.loadPresetParameters();
        }
        return this._presetParameterList;
    }

    private void loadPresetParameters() {
        this._presetParameterMap = new HashMap();
        this._presetParameterList = new ArrayList();
        this.loadDestinationParameters();
    }

    protected void addPresetParameter(String name, String value) {
        this._presetParameterMap.put(name, HttpUnitUtils.withNewValue((String[])this._presetParameterMap.get(name), value));
        this._presetParameterList.add(new LinkParameter(name, value));
    }
}

