/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors.win32;

import monalipse.editors.win32.OleAutomationDelegate;
import monalipse.editors.win32.OleHTMLElement;
import monalipse.editors.win32.OleHTMLElementCollection;
import monalipse.editors.win32.OleHTMLScript;
import monalipse.editors.win32.OleHTMLWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class OleHTMLDocument
extends OleAutomationDelegate {
    public OleHTMLDocument(OleAutomation oleAutomation) {
        super(oleAutomation);
    }

    public void close() {
        this.invoke("close");
    }

    public void clear() {
        this.invoke("clear");
    }

    public void open(String url, String name) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"open", "url", "name"});
        this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(url), new Variant(name)}, new int[]{rgdispid[1], rgdispid[2]});
    }

    public OleHTMLScript getScript() {
        OleAutomation a = this.getAutomation("Script");
        if (a == null) {
            return null;
        }
        return new OleHTMLScript(a);
    }

    public OleHTMLElement getBody() {
        return new OleHTMLElement(this.getAutomation("Body"));
    }

    public OleHTMLWindow getParentWindow() {
        return new OleHTMLWindow(this.getAutomation("parentWindow"));
    }

    public void setLocation(String url) {
        this.set("location", url);
    }

    public String getLocation() {
        return this.getString("location");
    }

    public void setScrollLocation(Point location) {
        this.setScrollLeft(location.x);
        this.setScrollTop(location.y);
    }

    public void setScrollLeft(int val) {
        this.getBody().set("scrollLeft", val);
    }

    public void setScrollTop(int val) {
        this.getBody().set("scrollTop", val);
    }

    public Point getScrollLocation() {
        return new Point(this.getScrollLeft(), this.getScrollTop());
    }

    public int getScrollLeft() {
        return this.getBody().getInt("scrollLeft");
    }

    public int getScrollTop() {
        return this.getBody().getInt("scrollTop");
    }

    public int write(String text) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"write", "psarray"});
        Variant pVarResult = this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(text)}, new int[]{rgdispid[1]});
        if (pVarResult == null) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public OleHTMLElement elementFromPoint(long x, long y) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"elementFromPoint", "x", "y"});
        Variant pVarResult = this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant((float)x), new Variant((float)y)}, new int[]{rgdispid[1], rgdispid[2]});
        if (pVarResult == null) {
            return null;
        }
        return new OleHTMLElement(pVarResult.getAutomation());
    }

    public OleHTMLElementCollection getElementsByName(String name) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"getElementsByName", "v"});
        Variant pVarResult = this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(name)}, new int[]{rgdispid[1]});
        if (pVarResult == null) {
            return null;
        }
        return new OleHTMLElementCollection(pVarResult.getAutomation());
    }

    public OleHTMLElement getElementById(String id) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"getElementById", "v"});
        Variant pVarResult = this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(id)}, new int[]{rgdispid[1]});
        if (pVarResult == null) {
            return null;
        }
        return new OleHTMLElement(pVarResult.getAutomation());
    }

    public OleHTMLElement getDocumentElement() {
        OleAutomation a = this.getAutomation("documentElement");
        if (a == null) {
            return null;
        }
        return new OleHTMLElement(a);
    }

    public OleHTMLElement importNode(OleHTMLElement importedNode, boolean deep) {
        int[] rgdispid = this.getAutomation().getIDsOfNames(new String[]{"importNode", "importedNode", "deep"});
        Variant pVarResult = this.getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(importedNode.getAutomation()), new Variant(deep)}, new int[]{rgdispid[1], rgdispid[2]});
        if (pVarResult == null) {
            return null;
        }
        return new OleHTMLElement(pVarResult.getAutomation());
    }
}

