/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import monalipse.MonalipsePlugin;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.server.giko.Board;
import monalipse.server.giko.Category;
import monalipse.server.giko.GikoServer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class BoardListContentProvider
extends LabelProvider
implements IBoardListContentProvider {
    private static String BBSMENU_URL = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
    public static String[] BBS_DOMAINS = new String[]{"2ch.net", "machibbs.com", "bbspink.com"};
    private static Transformer transformer;
    private IWorkbenchWindow workbenchWindow;
    private IProject input;
    private Category root;
    private Properties logMap;

    public BoardListContentProvider(IWorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
    }

    public static IFolder getLogFolderOf(IProject input, String baseURL) {
        block6: {
            Properties logMap = new Properties();
            IFile mapFile = input.getFile(".logmap");
            try {
                MonalipsePlugin.ensureSynchronized(mapFile);
                if (!mapFile.exists()) break block6;
                InputStream in = mapFile.getContents();
                try {
                    logMap.load(in);
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    in.close();
                    throw throwable;
                }
                Object var5_9 = null;
                in.close();
                String log = logMap.getProperty(baseURL);
                if (log != null) {
                    return input.getFolder(log);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean resourceChanged(IResourceChangeEvent event) {
        return this.input != null && AbstractBBSServer.resourceModified(7, event.getDelta(), (IResource)this.input.getFile(".bbsmenu"));
    }

    public String getText(Object element) {
        if (element instanceof Category) {
            return ((Category)element).getName();
        }
        if (element instanceof Board) {
            return ((Board)element).getName();
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        String imageKey = "IMG_OBJ_ELEMENTS";
        if (element instanceof Category) {
            imageKey = "IMG_OBJ_FOLDER";
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }

    public boolean hasChildren(Object element) {
        if (element == this.input) {
            return this.root.hasChildren();
        }
        if (element instanceof Category) {
            return ((Category)element).hasChildren();
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.input) {
            return this.root.getChildren();
        }
        if (parentElement instanceof Category) {
            return ((Category)parentElement).getChildren();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element == this.input) {
            return this.root;
        }
        if (element instanceof Category) {
            return ((Category)element).getCategory();
        }
        if (element instanceof Board) {
            return ((Board)element).getCategory();
        }
        return this.root;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        block15: {
            this.input = null;
            if (newInput instanceof IProject) {
                this.input = (IProject)newInput;
            }
            this.logMap = new Properties();
            if (this.input != null) {
                IFile mapFile = this.input.getFile(".logmap");
                try {
                    MonalipsePlugin.ensureSynchronized(mapFile);
                    if (!mapFile.exists()) break block15;
                    InputStream in = mapFile.getContents();
                    try {
                        this.logMap.load(in);
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        in.close();
                        throw throwable;
                    }
                    Object var6_11 = null;
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        Category oldRoot = this.root;
        this.root = new Category(null, "<root>");
        Document doc = this.getCachedMenu();
        if (doc != null) {
            BoardListContentProvider.parseBBSMenu(doc.getDocumentElement(), this.root, null);
            final ArrayList<String> urlList = new ArrayList<String>();
            Object[] categories = this.root.getChildren();
            int i = 0;
            while (i < categories.length) {
                Category category = (Category)categories[i];
                Object[] boards = category.getChildren();
                int j = 0;
                while (j < boards.length) {
                    Board oldBoard;
                    Category oldCategory;
                    Board board = (Board)boards[j];
                    String url = board.getURL().toExternalForm();
                    String log = this.logMap.getProperty(url);
                    if (log == null && oldRoot != null && (oldCategory = (Category)oldRoot.getChild(category.getName())) != null && (oldBoard = (Board)oldCategory.getChild(board.getName())) != null) {
                        log = this.logMap.getProperty(oldBoard.getURL().toExternalForm());
                    }
                    if (log == null) {
                        log = "log" + ((Hashtable)this.logMap).size();
                    }
                    if (!this.logMap.getProperty(log, "").equals(url)) {
                        urlList.add(url);
                    }
                    this.logMap.setProperty(url, log);
                    this.logMap.setProperty(log, url);
                    board.setLogFolder(this.input.getFolder(log));
                    ++j;
                }
                ++i;
            }
            if (urlList.size() > 0) {
                GikoServer.asyncExec(this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                        monitor.beginTask("", urlList.size());
                        int i = 0;
                        while (i < urlList.size()) {
                            String url = (String)urlList.get(i);
                            IFolder logFolder = BoardListContentProvider.this.input.getFolder((String)((Hashtable)BoardListContentProvider.this.logMap).get(url));
                            try {
                                if (!logFolder.exists()) {
                                    logFolder.create(false, true, null);
                                }
                                IFile locationFile = logFolder.getFile(".location");
                                MonalipsePlugin.ensureSynchronized(locationFile);
                                if (locationFile.exists()) {
                                    locationFile.setContents(MonalipsePlugin.getUTFInputStream(url), false, false, null);
                                } else {
                                    locationFile.create(MonalipsePlugin.getUTFInputStream(url), false, null);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                    }
                });
            }
        }
        if (this.input != null) {
            final IFile mapFile = this.input.getFile(".logmap");
            GikoServer.asyncExec(this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        MonalipsePlugin.ensureSynchronized(mapFile);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        BoardListContentProvider.this.logMap.store(bout, "");
                        bout.close();
                        if (mapFile.exists()) {
                            mapFile.setContents((InputStream)new ByteArrayInputStream(bout.toByteArray()), false, false, null);
                        } else {
                            mapFile.create((InputStream)new ByteArrayInputStream(bout.toByteArray()), false, null);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private Document getCachedMenu() {
        if (this.input != null) {
            IFile file = this.input.getFile(".bbsmenu");
            try {
                Document document;
                MonalipsePlugin.ensureSynchronized(file);
                if (!file.exists()) {
                    return null;
                }
                InputStream in = file.getContents();
                try {
                    DOMResult res = new DOMResult();
                    BoardListContentProvider.getTransformer().transform(new StreamSource(in), res);
                    document = (Document)res.getNode();
                    Object var4_8 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                return document;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setCachedMenu(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BoardListContentProvider.getTransformer().transform(new DOMSource(doc), new StreamResult(bout));
        bout.close();
        final byte[] bytes = bout.toByteArray();
        GikoServer.asyncExec(this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IFile cache = BoardListContentProvider.this.input.getFile(".bbsmenu");
                    MonalipsePlugin.ensureSynchronized(cache);
                    if (cache.exists()) {
                        cache.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, monitor);
                    } else {
                        cache.create((InputStream)new ByteArrayInputStream(bytes), false, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    private static void parseBBSMenu(Element element, Category root, Category category) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element child = (Element)children.item(i);
                if (child.getTagName().equals("a") && category != null) {
                    try {
                        String url = child.getAttribute("href");
                        URL href = new URL(url);
                        String name = child.getFirstChild().getNodeValue();
                        if (BoardListContentProvider.isBBS(href)) {
                            if (!category.hasChildren()) {
                                root.addChild(category);
                            }
                            category.addChild(new Board(category, name, href));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (child.getTagName().equals("b")) {
                    String s = child.getFirstChild().getNodeValue();
                    if (s.length() > 0) {
                        category = new Category(root, s);
                    }
                } else {
                    BoardListContentProvider.parseBBSMenu(child, root, category);
                }
            }
            ++i;
        }
    }

    private static boolean isBBS(URL href) {
        int i = 0;
        while (i < BBS_DOMAINS.length) {
            if (href.getHost().endsWith(BBS_DOMAINS[i]) && 1 < href.getFile().length() && href.getFile().endsWith("/")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateBoardList() {
        if (this.input == null) {
            return;
        }
        try {
            GetMethodWebRequest req = new GetMethodWebRequest(BBSMENU_URL);
            WebResponse wr = GikoServer.getWebConversation().getResponse(req);
            if (wr.getResponseCode() == 200) {
                this.setCachedMenu(wr.getDOM());
            }
            wr.getInputStream().close();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private static Transformer getTransformer() throws TransformerException {
        if (transformer == null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
        }
        return transformer;
    }
}

