/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import monalipse.MonalipsePlugin;
import monalipse.part.CancelableRunner;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IThreadContentProvider;
import monalipse.server.ResponseData;
import monalipse.server.giko.GikoServer;
import monalipse.server.giko.ThreadListFragment;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

class ThreadContentProvider
implements IAdaptable,
IThreadContentProvider {
    private static final int LOG_FILE_VERSION = 3;
    private IWorkbenchWindow workbenchWindow;
    private ThreadListFragment fragment;
    private String baseURL;
    private String urlHint;
    private IFolder logFolder;
    private String id;
    private int index;
    private String name;
    private int responses;

    public ThreadContentProvider(IWorkbenchWindow workbenchWindow, String baseURL, IFolder logFolder, String id, int index, String name, int responses) {
        this.workbenchWindow = workbenchWindow;
        this.baseURL = baseURL;
        this.logFolder = logFolder;
        this.id = id;
        this.index = index;
        this.name = name;
        this.responses = responses;
        int ss = baseURL.indexOf("//");
        if (ss != -1 && id.endsWith(".dat")) {
            int s = baseURL.indexOf(47, ss + 2);
            this.urlHint = String.valueOf(baseURL.substring(0, s)) + "/test/read.cgi" + baseURL.substring(s, baseURL.length()) + id.substring(0, id.length() - 4) + "/l50";
        }
    }

    public void setThreadListFragment(ThreadListFragment fragment) {
        this.fragment = fragment;
    }

    public ThreadListFragment getThreadListFragment() {
        return this.fragment;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getURLHint() {
        return this.urlHint;
    }

    public IFolder getLogFolder() {
        return this.logFolder;
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getResponseCountHint() {
        return this.responses;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadContentProvider) {
            ThreadContentProvider thread = (ThreadContentProvider)obj;
            return thread.logFolder.equals((Object)this.logFolder) && thread.id.equals(this.id);
        }
        return false;
    }

    public IResponseEnumeration getResponses(int sequence, int rangeStart) {
        FilterInputStream in;
        block11: {
            in = null;
            try {
                FilterInputStream din;
                IFile file = this.logFolder.getFile(this.id);
                MonalipsePlugin.ensureSynchronized(file);
                if (!file.exists() || ((DataInputStream)(din = (in = new DataInputStream(file.getContents())))).readInt() != 3) break block11;
                int seq = ((DataInputStream)din).readInt();
                String title = ((DataInputStream)din).readUTF();
                boolean partial = seq == sequence;
                ((DataInputStream)din).skipBytes(4);
                int count = ((DataInputStream)din).readInt();
                if (partial) {
                    try {
                        if (count < rangeStart) {
                            throw new IOException();
                        }
                        int i = 0;
                        while (i < rangeStart) {
                            ThreadContentProvider.skipResponseLog((DataInputStream)din);
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        din.close();
                        din = new DataInputStream(file.getContents());
                        ((DataInputStream)din).readInt();
                        ((DataInputStream)din).readInt();
                        ((DataInputStream)din).readInt();
                        return new ThreadLogReader(title, (DataInputStream)din, false, seq);
                    }
                }
                return new ThreadLogReader(title, (DataInputStream)din, partial, seq);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new NullResponseEnumeration("?", sequence);
    }

    /*
     * Loose catch block
     */
    public IResponseEnumeration updateResponses(CancelableRunner cancelable, int sequence, int rangeStart) {
        block26: {
            IFile file;
            GetMethodWebRequest req;
            WebConversation wc;
            block23: {
                wc = GikoServer.getWebConversation();
                req = new GetMethodWebRequest(String.valueOf(this.baseURL) + "dat/" + this.id);
                file = this.logFolder.getFile(this.id);
                try {
                    DataInputStream din;
                    block24: {
                        boolean partial;
                        MonalipsePlugin.ensureSynchronized(file);
                        if (!file.exists()) break block23;
                        din = new DataInputStream(file.getContents());
                        if (din.readInt() != 3) break block24;
                        int seq = din.readInt();
                        String title = din.readUTF();
                        boolean bl = partial = seq == sequence;
                        if (!partial) break block24;
                        int rangeStartByte = din.readInt();
                        int count = din.readInt();
                        ResponseData lastResp = null;
                        ArrayList<ResponseData> log = new ArrayList<ResponseData>();
                        if (rangeStart <= count) {
                            while (din.available() > 0) {
                                lastResp = ThreadContentProvider.readResponseLog(din);
                                log.add(lastResp);
                            }
                        }
                        if (lastResp == null || rangeStart > log.size()) break block24;
                        req.setHeaderField("Range", "bytes=" + rangeStartByte + "-");
                        WebResponse wr = wc.getResponse(req);
                        if (wr.getResponseCode() != 206) break block24;
                        RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(rangeStartByte, wr.getInputStream());
                        InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                        int contentLength = 0;
                        try {
                            contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                        }
                        catch (RuntimeException runtimeException) {}
                        if (!lastResp.equals(ThreadContentProvider.readResponse(r))) break block27;
                        ThreadDownloader threadDownloader = new ThreadDownloader(title, cancelable, r, cin, true, seq, log, rangeStart, contentLength, file);
                        Object var19_30 = null;
                        try {
                            din.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        {
                            block27: {
                                return threadDownloader;
                            }
                            r.close();
                        }
                        catch (Throwable throwable) {
                            Object var19_31 = null;
                            try {
                                din.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                    Object var19_32 = null;
                    try {
                        din.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (HttpException e) {
                    e.printStackTrace();
                }
            }
            ++sequence;
            try {
                req.removeHeaderField("Range");
                WebResponse wr = wc.getResponse(req);
                if (wr.getResponseCode() != 200) break block26;
                RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(0, wr.getInputStream());
                InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                int contentLength = 0;
                try {
                    contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                }
                catch (RuntimeException runtimeException) {}
                return new ThreadDownloader("?", cancelable, r, cin, false, sequence, new ArrayList(), 0, contentLength, file);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
        }
        return new NullResponseEnumeration("?", sequence);
    }

    private static void skipResponseLog(DataInputStream din) throws IOException {
        din.skipBytes(din.readShort());
        din.skipBytes(din.readShort());
        din.skipBytes(din.readShort());
        din.skipBytes(din.readShort());
    }

    private static ResponseData readResponseLog(DataInputStream din) throws IOException {
        return new ResponseData(din.readUTF(), din.readUTF(), din.readUTF(), din.readUTF());
    }

    private static GikoResponseData readResponse(Reader r) throws IOException {
        String name = ThreadContentProvider.readToken(r);
        String mail = ThreadContentProvider.readToken(r);
        String date = ThreadContentProvider.readToken(r);
        String body = ThreadContentProvider.readToken(r);
        String title = null;
        int ch = r.read();
        if (ch != -1 && ch != 10) {
            StringBuffer buf = new StringBuffer();
            while (ch != -1 && ch != 10) {
                buf.append((char)ch);
                ch = r.read();
            }
            title = buf.toString();
        }
        if (name != null && mail != null && date != null && body != null) {
            return new GikoResponseData(name, mail, date, body, title);
        }
        return null;
    }

    private static String readToken(Reader r) throws IOException {
        StringBuffer buf = new StringBuffer(64);
        int ch;
        while ((ch = r.read()) != -1) {
            if (ch == 60) {
                ch = r.read();
                if (ch == 62) {
                    return buf.toString();
                }
                StringBuffer tagBuf = new StringBuffer(32);
                while (ch != 62) {
                    tagBuf.append((char)ch);
                    ch = r.read();
                    if (ch != -1) continue;
                    return null;
                }
                if (1 < tagBuf.length() && (tagBuf.charAt(0) == 'a' || tagBuf.charAt(0) == 'A') && Character.isWhitespace(tagBuf.charAt(1))) continue;
                buf.append('<').append(tagBuf).append('>');
                continue;
            }
            buf.append((char)ch);
        }
        return null;
    }

    static /* synthetic */ IFolder access$2(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.logFolder;
    }

    static /* synthetic */ String access$3(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.id;
    }

    private class ThreadDownloader
    implements IResponseEnumeration,
    IRunnableWithProgress {
        private String title;
        private Reader r;
        private RangeAnalyzeInputStream cin;
        private boolean partial;
        private int sequence;
        private List log;
        private IFile logFile;
        private int position;
        private int contentRange;
        private int contentLength;
        private boolean closed;

        public ThreadDownloader(String title, CancelableRunner cancelable, Reader r, RangeAnalyzeInputStream cin, boolean partial, int sequence, List log, int position, int contentLength, IFile logFile) {
            this.title = title;
            this.r = r;
            this.cin = cin;
            this.partial = partial;
            this.sequence = sequence;
            this.log = log;
            this.position = position;
            this.contentLength = contentLength;
            this.logFile = logFile;
            this.contentRange = cin.getRange();
            cancelable.run(null, this);
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    GikoResponseData resp;
                    boolean get = false;
                    while ((resp = ThreadContentProvider.readResponse(this.r)) != null) {
                        get = true;
                        this.log.add(resp);
                        if (this.log.size() == 1) {
                            this.title = resp.getTitle();
                        }
                        ThreadDownloader threadDownloader = this;
                        synchronized (threadDownloader) {
                            this.notifyAll();
                        }
                        Thread.yield();
                    }
                    if (get) {
                        this.setLog(this.cin.getRange());
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ThreadDownloader threadDownloader = this;
                synchronized (threadDownloader) {
                    this.notifyAll();
                    this.closed = true;
                    try {
                        this.r.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var5_7 = null;
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                this.notifyAll();
                this.closed = true;
                try {
                    this.r.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void setLog(int pos) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(3);
            dout.writeInt(this.sequence);
            dout.writeUTF(this.title);
            dout.writeInt(pos);
            dout.writeInt(this.log.size());
            int i = 0;
            while (i < this.log.size()) {
                ResponseData resp = (ResponseData)this.log.get(i);
                dout.writeUTF(resp.getName());
                dout.writeUTF(resp.getMail());
                dout.writeUTF(resp.getDate());
                dout.writeUTF(resp.getBody());
                ++i;
            }
            dout.close();
            byte[] bytes = bout.toByteArray();
            GikoServer.asyncExec(ThreadContentProvider.this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(this, bytes){
                private final /* synthetic */ ThreadDownloader this$1;
                private final /* synthetic */ byte[] val$bytes;
                {
                    this.this$1 = threadDownloader;
                    this.val$bytes = byArray;
                }

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile cache = ThreadContentProvider.access$2(ThreadDownloader.access$0(this.this$1)).getFile(ThreadContentProvider.access$3(ThreadDownloader.access$0(this.this$1)));
                        MonalipsePlugin.ensureSynchronized(cache);
                        if (cache.exists()) {
                            cache.setContents((InputStream)new ByteArrayInputStream(this.val$bytes), false, false, monitor);
                        } else {
                            cache.create((InputStream)new ByteArrayInputStream(this.val$bytes), false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return !this.closed && this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return !this.closed || this.position < this.log.size();
        }

        public ResponseData getNextResponse() throws InterruptedException {
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                while (!this.closed && this.position == this.log.size()) {
                    this.wait();
                }
            }
            if (this.position < this.log.size()) {
                return (ResponseData)this.log.get(this.position++);
            }
            return null;
        }

        public int getProgressHint() {
            if (this.contentLength == 0) {
                return 100;
            }
            return Math.max((this.cin.getRange() - this.contentRange) * 100 / this.contentLength, 100);
        }

        public void close() {
        }

        static /* synthetic */ ThreadContentProvider access$0(ThreadDownloader threadDownloader) {
            return threadDownloader.ThreadContentProvider.this;
        }
    }

    private static class RangeAnalyzeInputStream
    extends InputStream {
        private int range;
        private int lf;
        private int count;
        private InputStream in;

        public RangeAnalyzeInputStream(int range, InputStream in) {
            this.range = range;
            this.in = in;
            this.lf = range;
            this.count = range;
        }

        public int getRange() {
            return this.range;
        }

        public int read() throws IOException {
            int r = this.in.read();
            if (r == 10) {
                this.range = this.lf;
                this.lf = this.count + 1;
            }
            ++this.count;
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.in.read(b);
            int i = 0;
            while (i < r) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            int end = off + len;
            int i = off;
            while (i < end) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i - off + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }
    }

    private static class ThreadLogReader
    implements IResponseEnumeration {
        private String title;
        private DataInputStream din;
        private int sequence;
        private boolean partial;

        public ThreadLogReader(String title, DataInputStream din, boolean partial, int sequence) {
            this.title = title;
            this.din = din;
            this.sequence = sequence;
            this.partial = partial;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.hasNextResponse();
        }

        public boolean hasNextResponse() {
            try {
                return this.din.available() > 0;
            }
            catch (IOException iOException) {
                try {
                    this.din.close();
                }
                catch (IOException iOException2) {}
                return false;
            }
        }

        public ResponseData getNextResponse() {
            try {
                return ThreadContentProvider.readResponseLog(this.din);
            }
            catch (IOException iOException) {
                try {
                    this.din.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }

        public int getProgressHint() {
            return 100;
        }

        public void close() {
            try {
                this.din.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class NullResponseEnumeration
    implements IResponseEnumeration {
        private String title;
        private int sequence;

        public NullResponseEnumeration(String title, int sequence) {
            this.title = title;
            this.sequence = sequence;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public boolean hasNextResponse() {
            return false;
        }

        public ResponseData getNextResponse() {
            return null;
        }

        public int getProgressHint() {
            return 100;
        }

        public void close() {
        }
    }

    private static class GikoResponseData
    extends ResponseData {
        private String title;

        public GikoResponseData(String name, String mail, String date, String body, String title) {
            super(name, mail, date, body);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

