/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import monalipse.MonalipsePlugin;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IThreadListContentProvider;
import monalipse.server.giko.GikoServer;
import monalipse.server.giko.ThreadContentProvider;
import monalipse.server.giko.ThreadListFragment;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

class ThreadListContentProvider
extends LabelProvider
implements IThreadListContentProvider {
    private static final int SUBJECT_CACHE_VERSION = 1;
    private static final int THREAD_LIST_FRAGMENT_SIZE = 50;
    private IWorkbenchWindow workbenchWindow;
    private IFolder input;
    private Object[] fragments;
    private Map cacheMap;
    private String constraint;
    static /* synthetic */ Class class$0;

    public ThreadListContentProvider(IWorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
    }

    public boolean resourceChanged(IResourceChangeEvent event) {
        return this.input != null && AbstractBBSServer.resourceModified(7, event.getDelta(), (IResource)this.input.getFile(".subject"));
    }

    public Object[] getChangedItems(IResourceChangeEvent event) {
        ArrayList list = new ArrayList();
        this.getModifiedThread(event.getDelta(), list);
        if (list.size() > 0) {
            return list.toArray();
        }
        return null;
    }

    public void getModifiedThread(IResourceDelta delta, List list) {
        if (delta != null) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(7);
            int i = 0;
            while (i < affectedChildren.length) {
                IResource res = affectedChildren[i].getResource();
                if (this.cacheMap.containsKey(res.getName())) {
                    list.add(this.cacheMap.get(res.getName()));
                }
                this.getModifiedThread(affectedChildren[i], list);
                ++i;
            }
        }
    }

    public void setConstraint(String constraint) {
        this.constraint = constraint == null ? null : this.toRegularForm(constraint);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.input) {
            return this.fragments;
        }
        if (parentElement instanceof ThreadListFragment) {
            return ((ThreadListFragment)parentElement).getThreads();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ThreadContentProvider) {
            return ((ThreadContentProvider)element).getThreadListFragment();
        }
        if (element instanceof ThreadListFragment) {
            return ((ThreadListFragment)element).getRoot();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element == this.input || element instanceof ThreadListFragment;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ThreadContentProvider) {
            ThreadContentProvider thread = (ThreadContentProvider)element;
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(thread.getIndex() + 1);
                }
                case 1: {
                    return thread.getName();
                }
                case 2: {
                    return String.valueOf(thread.getResponseCountHint());
                }
                case 3: {
                    return this.getCachedCount(thread);
                }
                case 4: {
                    return this.getPersistentCountProperty(thread, ".read");
                }
            }
        } else if (element instanceof ThreadListFragment && columnIndex == 0) {
            ThreadListFragment fragment = (ThreadListFragment)element;
            return "" + (fragment.getStartPosition() + 1) + "..." + fragment.getEndPosition();
        }
        return "";
    }

    private String getCachedCount(ThreadContentProvider thread) {
        try {
            IFile file = this.input.getFile(thread.getID());
            if (file.exists()) {
                String string;
                DataInputStream din = new DataInputStream(file.getContents());
                try {
                    din.skipBytes(4);
                    din.skipBytes(4);
                    din.skipBytes(din.readShort());
                    din.skipBytes(4);
                    string = String.valueOf(din.readInt());
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    din.close();
                    throw throwable;
                }
                din.close();
                return string;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return "0";
    }

    private String getPersistentCountProperty(ThreadContentProvider thread, String type) {
        try {
            String count;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.editors.IThreadViewerEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((count = this.input.getPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(thread.getID()) + type))) == null) {
                count = "0";
            }
            return count;
        }
        catch (CoreException coreException) {
            return "0";
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = null;
        if (newInput instanceof IFolder) {
            this.input = (IFolder)newInput;
        }
        this.cacheMap = new HashMap();
        this.fragments = this.getCachedSubject().toArray();
    }

    private List getCachedSubject() {
        block12: {
            if (this.input != null) {
                IFile subject = this.input.getFile(".subject");
                try {
                    MonalipsePlugin.ensureSynchronized(subject);
                    if (!subject.exists()) break block12;
                    ArrayList<ThreadListFragment> list = new ArrayList<ThreadListFragment>();
                    DataInputStream din = new DataInputStream(subject.getContents());
                    try {
                        if (din.readInt() == 1) {
                            Collator jpCollator = Collator.getInstance(Locale.JAPANESE);
                            jpCollator.setStrength(0);
                            ArrayList<ThreadContentProvider> threads = new ArrayList<ThreadContentProvider>();
                            int num = din.readInt();
                            int i = 0;
                            while (i < num) {
                                String id = din.readUTF();
                                String title = din.readUTF();
                                int responses = din.readInt();
                                if (this.isVisible(title, this.constraint)) {
                                    threads.add(new ThreadContentProvider(this.workbenchWindow, this.getBaseURL(), this.input, id, threads.size(), title, responses));
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < threads.size()) {
                                ThreadContentProvider[] threadArray = new ThreadContentProvider[Math.min(threads.size() - i, 50)];
                                ThreadListFragment fragment = new ThreadListFragment(this.input, i, threadArray);
                                list.add(fragment);
                                int j = 0;
                                while (j < threadArray.length) {
                                    ThreadContentProvider thread;
                                    threadArray[j] = thread = (ThreadContentProvider)threads.get(i + j);
                                    thread.setThreadListFragment(fragment);
                                    this.cacheMap.put(thread.getID(), thread);
                                    ++j;
                                }
                                i += 50;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        din.close();
                        throw throwable;
                    }
                    Object var12_17 = null;
                    din.close();
                    return list;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ArrayList();
    }

    private boolean isVisible(String title, String constraint) {
        if (constraint == null || constraint.length() == 0) {
            return true;
        }
        return this.toRegularForm(title).indexOf(constraint) != -1;
    }

    private String toRegularForm(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\uff41' <= ch && ch <= '\uff5a') {
                ch = (char)(97 + (ch - 65345));
            } else if ('\uff21' <= ch && ch <= '\uff3a') {
                ch = (char)(97 + (ch - 65313));
            } else if ('A' <= ch && ch <= 'Z') {
                ch = (char)(97 + (ch - 65));
            } else if ('\uff10' <= ch && ch <= '\uff19') {
                ch = (char)(48 + (ch - 65296));
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    private void setCachedSubject(List list) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(1);
        dout.writeInt(list.size());
        int i = 0;
        while (i < list.size()) {
            ThreadContentProvider thread = (ThreadContentProvider)list.get(i);
            dout.writeUTF(thread.getID());
            dout.writeUTF(thread.getName());
            dout.writeInt(thread.getResponseCountHint());
            ++i;
        }
        dout.close();
        final byte[] bytes = bout.toByteArray();
        GikoServer.asyncExec(this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IFile cache = ThreadListContentProvider.this.input.getFile(".subject");
                    MonalipsePlugin.ensureSynchronized(cache);
                    if (cache.exists()) {
                        cache.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, monitor);
                    } else {
                        cache.create((InputStream)new ByteArrayInputStream(bytes), false, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    public String getBaseURL() {
        IFile locationFile = this.input.getFile(".location");
        if (!locationFile.exists()) {
            return null;
        }
        try {
            String string;
            DataInputStream din = new DataInputStream(locationFile.getContents());
            try {
                string = din.readUTF();
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                din.close();
                throw throwable;
            }
            din.close();
            return string;
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public void updateThreadList() {
        block22: {
            if (this.input == null) {
                return;
            }
            try {
                String location = this.getBaseURL();
                if (location == null) {
                    return;
                }
                GetMethodWebRequest req = new GetMethodWebRequest(new URL(location), "subject.txt");
                WebResponse wr = GikoServer.getWebConversation().getResponse(req);
                if (wr.getResponseCode() != 200) break block22;
                BufferedReader r = new BufferedReader(new InputStreamReader(wr.getInputStream(), "Windows-31J"));
                try {
                    ArrayList<ThreadContentProvider> list = new ArrayList<ThreadContentProvider>();
                    String delim = null;
                    String br = null;
                    while (true) {
                        Thread.yield();
                        String line = r.readLine();
                        if (line == null) break;
                        if ((line = line.trim()).length() <= 0) continue;
                        if (delim == null) {
                            int c = line.indexOf(",");
                            int b = line.indexOf("<>");
                            if (c == -1) {
                                if (b == -1) break;
                                delim = "<>";
                            } else if (b == -1) {
                                delim = ",";
                            } else if (c < b) {
                                delim = "b";
                            } else if (b < c) {
                                delim = "<>";
                            }
                            if (line.endsWith(")")) {
                                br = "(";
                            } else if (line.endsWith(">")) {
                                br = "<";
                            } else {
                                if (!line.endsWith("\uff09")) break;
                                br = "\uff08";
                            }
                        }
                        String id = line.substring(0, line.indexOf(delim));
                        String name = line.substring(id.length() + delim.length(), line.lastIndexOf(br));
                        int count = Integer.parseInt(line.substring(line.lastIndexOf(br) + 1, line.length() - 1));
                        ThreadContentProvider thread = new ThreadContentProvider(this.workbenchWindow, this.getBaseURL(), this.input, id, list.size(), name, count);
                        list.add(thread);
                    }
                    this.setCachedSubject(list);
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    r.close();
                    throw throwable;
                }
                Object var13_21 = null;
                r.close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }
}

