/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import monalipse.editors.IThreadViewerEditor;
import monalipse.editors.ThreadEditorInput;
import monalipse.part.CancelableRunner;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSServer;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadListContentProvider;
import monalipse.views.BoardListView;
import monalipse.views.NullTreeContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public class ThreadListView
extends ViewPart
implements ISelectionListener,
IResourceChangeListener,
SelectionListener {
    public static final String ID_THREAD_LIST;
    private static final String TAG_INPUT = "input";
    private static final String TAG_FOLDER = "folder";
    private static final String TAG_COLUMNWIDTH = "columnWidth";
    private static final String TAG_COLUMN = "column";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_LABEL = "label";
    private static final String TAG_TITLE = "title";
    private TableTreeViewer viewer;
    private IBBSServer server;
    private IThreadListContentProvider provider;
    private CancelableRunner cancelable;
    private IAction reloadAction;
    private IAction abortAction;
    private IAction doubleClickAction;
    private IMemento memento;
    private Combo searchCombo;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_THREAD_LIST = clazz.getName();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableTreeViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)new NullTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.makeColumns();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewer.getTableTree().addSelectionListener((SelectionListener)this);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.provider != null) {
            Object[] changed;
            if (this.provider.resourceChanged(event)) {
                this.refreshList();
                if (this.viewer.getVisibleExpandedElements().length == 0) {
                    this.expandFirstFragment();
                }
            }
            if ((changed = this.provider.getChangedItems(event)) != null) {
                this.viewer.update(changed, null);
            }
        }
    }

    private void refreshList() {
        if (this.provider != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            this.viewer.setInput(this.viewer.getInput());
            this.restoreState((IMemento)memento);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.viewer.getTableTree().isDisposed() && selection instanceof IStructuredSelection && part instanceof BoardListView) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            this.setTitle(((BoardListView)part).getBoardNameOf(first));
            IBBSServer server = ((BoardListView)part).getServer();
            if (this.server != server || this.viewer.getContentProvider() == null) {
                this.server = server;
                this.provider = server.getThreadListContentProvider();
                this.viewer.setContentProvider((IContentProvider)this.provider);
                this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
            }
            IFolder logFolder = server.getLogFolderOf(first);
            if (this.viewer.getInput() == null || logFolder != null && !this.viewer.getInput().equals(logFolder)) {
                if (this.viewer.getInput() instanceof IFolder) {
                    this.saveSearchWord((IResource)((IFolder)this.viewer.getInput()));
                }
                if (this.provider != null) {
                    this.provider.setConstraint("");
                }
                this.viewer.setInput((Object)logFolder);
                this.restoreSearchWord((IResource)logFolder);
                if (this.provider != null) {
                    this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ThreadListView.this.getSite().getPage().activate((IWorkbenchPart)ThreadListView.this);
                        }
                    });
                    if (this.provider.getElements(this.viewer.getInput()).length == 0) {
                        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ThreadListView.this.reloadAction.run();
                            }
                        });
                    } else {
                        this.expandFirstFragment();
                    }
                }
            }
        }
    }

    private void expandFirstFragment() {
        Object[] fragments = this.provider.getChildren(this.viewer.getInput());
        if (fragments.length > 0 && this.provider.hasChildren(fragments[0])) {
            this.viewer.setExpandedElements(new Object[]{fragments[0]});
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object first;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IThreadContentProvider) {
            IThreadContentProvider thread = (IThreadContentProvider)first;
            IWorkbenchPage page = this.getSite().getPage().getWorkbenchWindow().getActivePage();
            if (page.findEditor((IEditorInput)new ThreadEditorInput(thread)) != null) {
                try {
                    page.openEditor((IEditorInput)new ThreadEditorInput(thread), "monalipse.editors.ThreadViewerEditor");
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void saveSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                StringBuffer buf = new StringBuffer();
                String[] keys = this.searchCombo.getItems();
                int i = 0;
                while (i < keys.length && i < 10) {
                    buf.append(URLEncoder.encode(keys[i], "UTF-8")).append(" ");
                    ++i;
                }
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"), buf.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void restoreSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                this.searchCombo.removeAll();
                this.searchCombo.add("");
                String keys = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"));
                if (keys != null) {
                    StringTokenizer tk = new StringTokenizer(keys);
                    while (tk.hasMoreTokens()) {
                        this.searchCombo.add(URLDecoder.decode(tk.nextToken(), "UTF-8"));
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public void saveState(IMemento memento) {
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        this.saveColumnState(memento);
        this.saveInputState(memento);
        this.saveExpansionState(memento);
        this.saveSelectionState(memento);
    }

    private void saveColumnState(IMemento memento) {
        IMemento widthMem = memento.createChild(TAG_COLUMNWIDTH);
        int i = 0;
        while (i < this.viewer.getTableTree().getTable().getColumnCount()) {
            IMemento columnMem = widthMem.createChild(TAG_COLUMN);
            columnMem.putInteger(TAG_WIDTH, this.viewer.getTableTree().getTable().getColumn(i).getWidth());
            ++i;
        }
    }

    private void saveInputState(IMemento memento) {
        if (this.server != null) {
            IMemento elementMem = memento.createChild(TAG_INPUT);
            elementMem.putString(TAG_FOLDER, ((IFolder)this.viewer.getInput()).getFullPath().toString());
            elementMem.putString(TAG_TITLE, this.getTitle());
            this.saveSearchWord((IResource)((IFolder)this.viewer.getInput()));
        }
    }

    private void saveSelectionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_SELECTION), ((IStructuredSelection)this.viewer.getSelection()).toArray());
    }

    private void saveExpansionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_EXPANDED), this.viewer.getVisibleExpandedElements());
    }

    private void setElements(IMemento memento, Object[] elements) {
        if (this.provider == null) {
            return;
        }
        if (elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                while (this.provider.getParent(o) != null) {
                    IMemento labelMem = elementMem.createChild(TAG_LABEL);
                    labelMem.putString(TAG_LABEL, this.provider.getColumnText(o, 0));
                    o = this.provider.getParent(o);
                }
                ++i;
            }
        }
    }

    private void restoreState(IMemento memento) {
        this.restoreColumnState(memento);
        this.restoreInputState(memento);
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
    }

    private void restoreColumnState(IMemento memento) {
        IMemento[] columnMem;
        IMemento widthMem = memento.getChild(TAG_COLUMNWIDTH);
        if (widthMem != null && (columnMem = widthMem.getChildren(TAG_COLUMN)) != null) {
            int i = 0;
            while (i < this.viewer.getTableTree().getTable().getColumnCount() && i < columnMem.length) {
                this.viewer.getTableTree().getTable().getColumn(i).setWidth(columnMem[i].getInteger(TAG_WIDTH).intValue());
                ++i;
            }
        }
    }

    private void restoreInputState(IMemento memento) {
        IMemento elementMem = memento.getChild(TAG_INPUT);
        if (elementMem != null) {
            String title;
            String folder = elementMem.getString(TAG_FOLDER);
            if (folder != null) {
                IFolder fld = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folder));
                this.server = BBSServerManager.getInstanceOf(fld.getProject(), this.getSite().getWorkbenchWindow());
                if (this.server != null) {
                    this.provider = this.server.getThreadListContentProvider();
                    this.viewer.setContentProvider((IContentProvider)this.provider);
                    this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
                    this.viewer.setInput((Object)fld);
                    this.restoreSearchWord((IResource)fld);
                }
            }
            if ((title = elementMem.getString(TAG_TITLE)) != null) {
                this.setTitle(title);
            }
        }
    }

    private void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.getElements(childMem)));
        }
    }

    private void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            this.viewer.setExpandedElements(this.getElements(childMem).toArray());
        }
    }

    private List getElements(IMemento memento) {
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < elementMem.length) {
            IMemento[] labelMem = elementMem[i].getChildren(TAG_LABEL);
            Object[] children = this.provider.getElements(this.viewer.getInput());
            Object e = null;
            int j = labelMem.length - 1;
            while (j >= 0) {
                e = this.findElement(children, labelMem[j].getString(TAG_LABEL));
                if (e == null) break;
                children = this.provider.getChildren(e);
                --j;
            }
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private Object findElement(Object[] list, String label) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (this.provider.getColumnText(list[i], 0).equals(label)) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ThreadListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatuBar(bars.getStatusLineManager());
    }

    private void fillLocalStatuBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.add((IContributionItem)new ControlContribution(String.valueOf(clazz.getName()) + ".constrain"){

            protected Control createControl(Composite parent) {
                ThreadListView.this.searchCombo = new Combo(parent, 4);
                ThreadListView.this.searchCombo.setToolTipText("Search");
                ThreadListView.this.searchCombo.add("");
                if (ThreadListView.this.viewer.getInput() instanceof IFolder) {
                    ThreadListView.this.restoreSearchWord((IResource)((IFolder)ThreadListView.this.viewer.getInput()));
                }
                ThreadListView.this.searchCombo.addSelectionListener(new SelectionListener(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    private void selected(SelectionEvent e) {
                        String text = ThreadListView.access$3(4.access$0(this.this$1)).getText();
                        if (text.length() > 0) {
                            if (Arrays.asList(ThreadListView.access$3(4.access$0(this.this$1)).getItems()).contains(text)) {
                                ThreadListView.access$3(4.access$0(this.this$1)).remove(text);
                            }
                            ThreadListView.access$3(4.access$0(this.this$1)).add(text, 1);
                        }
                        ThreadListView.access$6(4.access$0(this.this$1)).setConstraint(text);
                        ThreadListView.access$7(4.access$0(this.this$1));
                        ThreadListView.access$3(4.access$0(this.this$1)).setText(text);
                        if (ThreadListView.access$4(4.access$0(this.this$1)).getVisibleExpandedElements().length == 0) {
                            ThreadListView.access$8(4.access$0(this.this$1));
                        }
                    }
                });
                return ThreadListView.this.searchCombo;
            }

            static /* synthetic */ ThreadListView access$0(4 var0) {
                return var0.ThreadListView.this;
            }
        });
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
    }

    private void makeColumns() {
        TableTree table = this.viewer.getTableTree();
        table.getTable().setHeaderVisible(true);
        table.getTable().setLinesVisible(true);
        TableColumn col = new TableColumn(table.getTable(), 16384);
        col.setText("Rank");
        col.setWidth(80);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Title");
        col.setWidth(400);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Response");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Cache");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Read");
        col.setWidth(50);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.run((Object)ThreadListView.this.cancelable, new IRunnableWithProgress(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (ThreadListView.access$6(6.access$0(this.this$1)) != null) {
                            ThreadListView.access$6(6.access$0(this.this$1)).updateThreadList();
                        }
                    }
                });
            }

            static /* synthetic */ ThreadListView access$0(6 var0) {
                return var0.ThreadListView.this;
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload thread list");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.doubleClickAction = new Action(){

            public void run() {
                Object first;
                ISelection selection = ThreadListView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IThreadContentProvider) {
                    IThreadContentProvider thread = (IThreadContentProvider)first;
                    IWorkbenchPage page = ThreadListView.this.getSite().getPage().getWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart part;
                        ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("monalipse.editors.win32.ThreadViewerEditorWin32");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof IThreadViewerEditor) {
                            ((IThreadViewerEditor)part).updateThread();
                        }
                    }
                    catch (PartInitException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ThreadListView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ IThreadListContentProvider access$6(ThreadListView threadListView) {
        return threadListView.provider;
    }

    static /* synthetic */ void access$7(ThreadListView threadListView) {
        threadListView.refreshList();
    }

    static /* synthetic */ void access$8(ThreadListView threadListView) {
        threadListView.expandFirstFragment();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

