/*
 * Decompiled with CFR 0.152.
 */
package monalipse.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import monalipse.MonalipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewMonalipseProjectCreationWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;
    private IConfigurationElement configElement;
    private static String PAGE_PROBLEMS_TITLE = MonalipsePlugin.getResourceString("NewProject.errorOpeningPage");
    private static String WINDOW_PROBLEMS_TITLE = MonalipsePlugin.getResourceString("NewProject.errorOpeningWindow");

    public NewMonalipseProjectCreationWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = workbenchSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.setDialogSettings(section);
    }

    protected abstract Class getBBSServerImplClass();

    protected abstract String getInitialProjectName();

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("monalipseNewProjectPage"){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.validate((Control)parent);
            }

            private void validate(Control control) {
                Text text;
                if (control instanceof Composite) {
                    Control[] children = ((Composite)control).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.validate(children[i]);
                        ++i;
                    }
                } else if (control instanceof Text && (text = (Text)control).getText().equals(NewMonalipseProjectCreationWizard.this.getInitialProjectName())) {
                    NewMonalipseProjectCreationWizard.this.getShell().getDisplay().asyncExec(new Runnable(this, text){
                        private final /* synthetic */ Text val$text;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$text = text;
                        }

                        public void run() {
                            this.val$text.setText(1.access$0(this.this$1).getInitialProjectName());
                        }
                    });
                }
            }

            static /* synthetic */ NewMonalipseProjectCreationWizard access$0(1 var0) {
                return var0.NewMonalipseProjectCreationWizard.this;
            }
        };
        this.mainPage.setTitle(MonalipsePlugin.getResourceString("NewProject.title"));
        this.mainPage.setDescription(MonalipsePlugin.getResourceString("NewProject.description"));
        this.mainPage.setInitialProjectName(this.getInitialProjectName());
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject() {
        IPath newPath;
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.mainPage.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewMonalipseProjectCreationWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.caseVariantExistsError", new String[]{newProjectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.internalError", new Object[]{t.getMessage()}));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private static void addMonalipseNature(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        if (!project.hasNature("monalipse.monalipsenature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "monalipse.monalipsenature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
        monitor.worked(1);
        monitor.done();
    }

    private void configureProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(".classname");
        try {
            file.create(MonalipsePlugin.getUTFInputStream(this.getBBSServerImplClass().getName()), true, monitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 4000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            NewMonalipseProjectCreationWizard.addMonalipseNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.configureProject(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MonalipsePlugin.getResourceString("NewProject.windowTitle"));
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }
}

