/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.JTidyPrintWriter;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

class ReceivedPage
extends ParsedHTML {
    private static String _utfEncodingName;

    public ReceivedPage(URL url, String parentTarget, String pageText, String characterSet) throws SAXException {
        super(url, parentTarget, ReceivedPage.getDOM(url, pageText), characterSet);
        this.setBaseAttributes();
    }

    public String getTitle() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("title");
        if (nl.getLength() == 0) {
            return "";
        }
        if (!nl.item(0).hasChildNodes()) {
            return "";
        }
        return nl.item(0).getFirstChild().getNodeValue();
    }

    public String getExternalStyleSheet() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("link");
        int length = nl.getLength();
        if (length == 0) {
            return "";
        }
        int i = 0;
        while (i < length) {
            if ("stylesheet".equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), "rel"))) {
                return NodeUtils.getNodeAttribute(nl.item(i), "href");
            }
            ++i;
        }
        return "";
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) {
        Vector<String> matches = new Vector<String>();
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("meta");
        int length = nl.getLength();
        int i = 0;
        while (i < length) {
            if (attributeValue.equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), attribute))) {
                matches.addElement(NodeUtils.getNodeAttribute(nl.item(i), "content"));
            }
            ++i;
        }
        Object[] result = new String[matches.size()];
        matches.copyInto(result);
        return result;
    }

    private static Node getDOM(URL url, String pageText) throws SAXException {
        try {
            return ReceivedPage.getParser(url).parseDOM(new ByteArrayInputStream(pageText.getBytes(ReceivedPage.getUTFEncodingName())), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    private static String getUTFEncodingName() {
        if (_utfEncodingName == null) {
            String versionNum = System.getProperty("java.version");
            _utfEncodingName = versionNum.startsWith("1.1") ? "UTF8" : "UTF-8";
        }
        return _utfEncodingName;
    }

    private void setBaseAttributes() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("base");
        if (nl.getLength() == 0) {
            return;
        }
        try {
            this.applyBaseAttributes(NodeUtils.getNodeAttribute(nl.item(0), "href"), NodeUtils.getNodeAttribute(nl.item(0), "target"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to set document base: " + e);
        }
    }

    private void applyBaseAttributes(String baseURLString, String baseTarget) throws MalformedURLException {
        if (baseURLString.length() > 0) {
            this.setBaseURL(new URL(baseURLString));
        }
        if (baseTarget.length() > 0) {
            this.setBaseTarget(baseTarget);
        }
    }

    private static Tidy getParser(URL url) {
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(HttpUnitOptions.getParserWarningsEnabled());
        if (!HttpUnitOptions.getHtmlErrorListeners().isEmpty()) {
            tidy.setErrout(new JTidyPrintWriter(url));
        }
        return tidy;
    }
}

