package monalipse.server;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import monalipse.MonalipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;

public class BBSServerManager
{
	private static Map instances = new HashMap();
	
	public static IThreadContentProvider getThreadContentProviderOf(URL url, IWorkbenchWindow workbenchWindow)
	{
		IWorkspace ws = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = ws.getRoot();
		IProject[] proj = root.getProjects();
		for(int i = 0; i < proj.length; i++)
		{
			IBBSServer server = getInstanceOf(proj[i], workbenchWindow);
			if(server.isSupported(url))
				return server.getThreadContentProviderOf(proj[i], url);
		}
		return null;
	}

	public static IBBSServer getInstanceOf(IProject project, IWorkbenchWindow workbenchWindow)
	{
		try
		{
			if(project.getNature(MonalipsePlugin.NATURE_ID) != null)
			{
				IFile f = project.getFile(".classname");
				if(f.exists())
				{
					DataInputStream din = new DataInputStream(f.getContents(true));
					try
					{
						try
						{
							return getInstanceOf(din.readUTF(), workbenchWindow, project);
						}
						finally
						{
							din.close();
						}
					}
					catch (IOException e)
					{
					}
				}
			}
		}
		catch (CoreException e)
		{
		}
		
		return null;
	}

	public static IBBSServer getInstanceOf(String target, IWorkbenchWindow workbenchWindow)
	{
		IProject[] proj = ResourcesPlugin.getWorkspace().getRoot().getProjects();
		for(int i = 0; i < proj.length; i++)
		{
			try
			{
				if(proj[i].getNature(MonalipsePlugin.NATURE_ID) != null)
				{
					IFile f = proj[i].getFile(".classname");
					if(f.exists())
					{
						DataInputStream din = new DataInputStream(f.getContents(true));
						try
						{
							try
							{
								String className = din.readUTF();
								if(className.equals(target))
									return getInstanceOf(target, workbenchWindow, proj[i]);
							}
							finally
							{
								din.close();
							}
						}
						catch (IOException e)
						{
						}
					}
				}
			}
			catch (CoreException e)
			{
			}
		}

		return null;
	}

	private static IBBSServer getInstanceOf(String target, IWorkbenchWindow workbenchWindow, IProject project)
	{
		synchronized(instances)
		{
			if(instances.containsKey(project.getName()))
				return (IBBSServer)instances.get(project.getName());
			
			try
			{
				IBBSServer server = (IBBSServer) Class.forName(target).newInstance();
				server.initialize(workbenchWindow, project);
				instances.put(project.getName(), server);
				return server;
			}
			catch(InstantiationException e)
			{
				throw new RuntimeException(e);
			}
			catch(IllegalAccessException e)
			{
				throw new RuntimeException(e);
			}
			catch(ClassNotFoundException e)
			{
				throw new RuntimeException(e);
			}
		}
	}
}
