package monalipse.server.giko;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import monalipse.MonalipsePlugin;
import monalipse.editors.IThreadViewerEditor;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IThreadListContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

class ThreadListContentProvider extends LabelProvider implements IThreadListContentProvider
{
	private static final int SUBJECT_CACHE_VERSION = 0x01;
	private static final int THREAD_LIST_FRAGMENT_SIZE = 50;

	private IWorkbenchWindow workbenchWindow;
	private IFolder input;
	private Object[] fragments;
	private Map cacheMap;
	private String constraint;

	public ThreadListContentProvider(IWorkbenchWindow workbenchWindow)
	{
		this.workbenchWindow = workbenchWindow;
	}
	
	public boolean resourceChanged(IResourceChangeEvent event)
	{
		return input != null && AbstractBBSServer.resourceModified(IResourceDelta.ADDED | IResourceDelta.REMOVED | IResourceDelta.CHANGED, event.getDelta(), input.getFile(".subject"));
	}
	
	public Object[] getChangedItems(IResourceChangeEvent event)
	{
		List list = new ArrayList();
		getModifiedThread(event.getDelta(), list);
		if(0 < list.size())
			return list.toArray();
		else
			return null;
	}

	public void getModifiedThread(IResourceDelta delta, List list)
	{
		if(delta != null)
		{
			IResourceDelta[] affectedChildren = delta.getAffectedChildren(IResourceDelta.ADDED | IResourceDelta.REMOVED | IResourceDelta.CHANGED);
			for (int i = 0; i < affectedChildren.length; i++)
			{
				IResource res = affectedChildren[i].getResource();
				if(cacheMap.containsKey(res.getName()))
					list.add(cacheMap.get(res.getName()));
				getModifiedThread(affectedChildren[i], list);
			}
		}
	}
	
	public void setConstraint(String constraint)
	{
		if(constraint == null)
			this.constraint = null;
		else
			this.constraint = toRegularForm(constraint);
	}

	public Object[] getElements(Object inputElement)
	{
		return getChildren(inputElement);
	}

	public Object[] getChildren(Object parentElement)
	{
		if(parentElement == input)
			return fragments;
		else if(parentElement instanceof ThreadListFragment)
			return ((ThreadListFragment)parentElement).getThreads();
		else
			return new Object[0];
	}

	public Object getParent(Object element)
	{
		if(element instanceof ThreadContentProvider)
			return ((ThreadContentProvider)element).getThreadListFragment();
		else if(element instanceof ThreadListFragment)
			return ((ThreadListFragment)element).getRoot();
		else 
			return null;
	}

	public boolean hasChildren(Object element)
	{
		return element == input || element instanceof ThreadListFragment;
	}

	public Image getColumnImage(Object element, int columnIndex)
	{
		return null;
	}

	public String getColumnText(Object element, int columnIndex)
	{
		if(element instanceof ThreadContentProvider)
		{
			ThreadContentProvider thread = (ThreadContentProvider)element;
			switch(columnIndex)
			{
			case 0:
				return String.valueOf(thread.getIndex() + 1);
			
			case 1:
				return thread.getName();
			
			case 2:
				return String.valueOf(thread.getResponseCountHint());
			
			case 3:
				return getCachedCount(thread);
			
			case 4:
				return getPersistentCountProperty(thread, ".read");
			}
		}
		else if(element instanceof ThreadListFragment)
		{
			if(columnIndex == 0)
			{
				ThreadListFragment fragment = (ThreadListFragment)element;
				return "" + (fragment.getStartPosition() + 1) + "..." + fragment.getEndPosition();
			}
		}
		return "";
	}
	
	private String getCachedCount(ThreadContentProvider thread)
	{
		try
		{
			IFile file = input.getFile(thread.getID());
			if(file.exists())
			{
				DataInputStream din = new DataInputStream(file.getContents());
				try
				{
					din.skipBytes(4);
					din.skipBytes(4);
					din.skipBytes(din.readShort());
					din.skipBytes(4);
					return String.valueOf(din.readInt());
				}
				finally
				{
					din.close();
				}
			}
		}
		catch (CoreException e)
		{
		}
		catch (IOException e)
		{
		}
		return "0";
	}
	
	private String getPersistentCountProperty(ThreadContentProvider thread, String type)
	{
		try
		{
			String count = input.getPersistentProperty(new QualifiedName(IThreadViewerEditor.class.getName(), thread.getID() + type));
			if(count == null)
				count = "0";
			return count;
		}
		catch (CoreException e)
		{
			return "0";
		}
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
	{
		input = null;

		if(newInput instanceof IFolder)
			input = (IFolder)newInput;
		
		cacheMap = new HashMap();
		fragments = getCachedSubject().toArray();
	}

	private List getCachedSubject()
	{
		if(input != null)
		{
			IFile subject = input.getFile(".subject");
			try
			{
				MonalipsePlugin.ensureSynchronized(subject);
				if(subject.exists())
				{
					List list = new ArrayList();
					DataInputStream din = new DataInputStream(subject.getContents());
					try
					{
						if(din.readInt() == SUBJECT_CACHE_VERSION)
						{
							Collator jpCollator = Collator.getInstance(Locale.JAPANESE);
							jpCollator.setStrength(Collator.PRIMARY);

							List threads = new ArrayList();
							int num = din.readInt();
							for(int i = 0; i < num; i++)
							{
								String id = din.readUTF();
								String title = din.readUTF();
								int responses = din.readInt();
								if(isVisible(title, constraint))
									threads.add(new ThreadContentProvider(workbenchWindow, getBaseURL(), input, id, threads.size(), title, responses));
							}

							for(int i = 0; i < threads.size(); i += THREAD_LIST_FRAGMENT_SIZE)
							{
								ThreadContentProvider[] threadArray = new ThreadContentProvider[Math.min(threads.size() - i, THREAD_LIST_FRAGMENT_SIZE)];
								ThreadListFragment fragment = new ThreadListFragment(input, i, threadArray);
								list.add(fragment);
								
								for(int j = 0; j < threadArray.length; j++)
								{
									ThreadContentProvider thread = (ThreadContentProvider)threads.get(i + j);
									threadArray[j] = thread;
									thread.setThreadListFragment(fragment);
									cacheMap.put(thread.getID(), thread);
								}
							}
						}
					}
					finally
					{
						din.close();
					}
					return list;
				}
			}
			catch (MalformedURLException e)
			{
				e.printStackTrace();
			}
			catch (CoreException e)
			{
				e.printStackTrace();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}

		return new ArrayList();
	}
	
	private boolean isVisible(String title, String constraint)
	{
		if(constraint == null || constraint.length() == 0)
			return true;
		return toRegularForm(title).indexOf(constraint) != -1;
	}
	
	private String toRegularForm(String str)
	{
		StringBuffer buf = new StringBuffer();
		for(int i = 0; i < str.length(); i++)
		{
			char ch = str.charAt(i);
			if('\uff41' <= ch && ch <= '\uff5a')
				ch = (char)('a' + (ch - '\uff41'));
			else if('\uff21' <= ch && ch <= '\uff3a')
				ch = (char)('a' + (ch - '\uff21'));
			else if('A' <= ch && ch <= 'Z')
				ch = (char)('a' + (ch - 'A'));
			else if('\uff10' <= ch && ch <= '\uff19')
				ch = (char)('0' + (ch - '\uff10'));
			buf.append((char)ch);
		}
		return buf.toString();
	}
	
	private void setCachedSubject(List list) throws IOException
	{
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		dout.writeInt(SUBJECT_CACHE_VERSION);
		dout.writeInt(list.size());
		for(int i = 0; i < list.size(); i++)
		{
			ThreadContentProvider thread = (ThreadContentProvider)list.get(i);
			dout.writeUTF(thread.getID());
			dout.writeUTF(thread.getName());
			dout.writeInt(thread.getResponseCountHint());
		}
		dout.close();
		final byte[] bytes = bout.toByteArray();
		GikoServer.asyncExec(workbenchWindow, new WorkspaceModifyOperation()
			{
				protected void execute(IProgressMonitor monitor) throws InvocationTargetException
				{
					try
					{
						IFile cache = input.getFile(".subject");
						MonalipsePlugin.ensureSynchronized(cache);
						if(cache.exists())
							cache.setContents(new ByteArrayInputStream(bytes), false, false, monitor);
						else
							cache.create(new ByteArrayInputStream(bytes), false, monitor);
					}
					catch (CoreException e)
					{
						throw new InvocationTargetException(e);
					}
				}
			});
	}
	
	public String getBaseURL()
	{
		IFile locationFile = input.getFile(".location");
		if(!locationFile.exists())
			return null;

		try
		{
			DataInputStream din = new DataInputStream(locationFile.getContents());
			try
			{
				return din.readUTF();
			}
			finally
			{
				din.close();
			}
		}
		catch (CoreException e)
		{
		}
		catch (IOException e)
		{
		}
		
		return null;
	}

	public void updateThreadList()
	{
		if(input == null)
			return;
		
		try
		{
			String location = getBaseURL();
			if(location == null)
				return;
			
			WebRequest req = new GetMethodWebRequest(new URL(location), "subject.txt");
//			req.setHeaderField("User-Agent", "Monazilla/1.00 (monalipse/0.01)");
			WebResponse wr = GikoServer.getWebConversation().getResponse(req);
			
			if(wr.getResponseCode() == 200)
			{
				BufferedReader r = new BufferedReader(new InputStreamReader(wr.getInputStream(), "Windows-31J"));
				try
				{
					List list = new ArrayList();
					String delim = null;
					String br = null;
					while(true)
					{
						Thread.yield();
						String line = r.readLine();
						if(line == null)
							break;
						line = line.trim();
						if(0 < line.length())
						{
							if(delim == null)
							{
								int c = line.indexOf(",");
								int b = line.indexOf("<>");
								if(c == -1)
								{
									if(b == -1)
										break;
									else
										delim = "<>";
								}
								else
								{
									if(b == -1)
										delim = ",";
									else if(c < b)
										delim = "b";
									else if(b < c)
										delim = "<>";
								}
								
								if(line.endsWith(")"))
									br = "(";
								else if(line.endsWith(">"))
									br = "<";
								else if(line.endsWith("\uff09")) // FULLWIDTH RIGHT PARENTHESIS
									br = "\uff08"; // FULLWIDTH LEFT PARENTHESIS
								else
									break;
							}
							
							String id = line.substring(0, line.indexOf(delim));
							String name = line.substring(id.length() + delim.length(), line.lastIndexOf(br));
							int count = Integer.parseInt(line.substring(line.lastIndexOf(br) + 1, line.length() - 1));
							
							ThreadContentProvider thread = new ThreadContentProvider(workbenchWindow, getBaseURL(), input, id, list.size(), name, count);
							list.add(thread);
						}
					}
					
					setCachedSubject(list);
				}
				finally
				{
					r.close();
				}
			}
		}
		catch (MalformedURLException e)
		{
			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		catch (SAXException e)
		{
			e.printStackTrace();
		}
	}

}
