/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.IllegalParameterValueException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SelectionFormControl
extends FormControl {
    private final boolean _multiSelect;
    private final boolean _listBox;
    private final String[] _optionValues;
    private final String[] _displayedOptions;
    private String[] _values;
    private boolean[] _selectionIndexes;
    private boolean[] _initialIndexes;

    SelectionFormControl(Node node) {
        super(node);
        if (!node.getNodeName().equalsIgnoreCase("select")) {
            throw new RuntimeException("Not a select element");
        }
        this._multiSelect = NodeUtils.isNodeAttributePresent(node, "multiple");
        this._listBox = this._multiSelect || NodeUtils.isNodeAttributePresent(node, "size");
        this._optionValues = this.getInitialOptionValues(node);
        this._displayedOptions = this.getInitialDisplayedOptions(node);
        this._initialIndexes = this.getInitialSelectionIndexes(node);
        this._selectionIndexes = (boolean[])this._initialIndexes.clone();
        this._values = this.getSelectedValues(this._selectionIndexes, this._optionValues);
    }

    public String[] getValues() {
        return this._values;
    }

    public String[] getOptionValues() {
        return this._optionValues;
    }

    public String[] getDisplayedOptions() {
        return this._displayedOptions;
    }

    public boolean isMultiValued() {
        return this._multiSelect;
    }

    void updateRequiredParameters(Hashtable required) {
        if (this.isReadOnly()) {
            required.put(this.getName(), this.getValues());
        }
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        int i = 0;
        while (i < this.getValues().length) {
            processor.addParameter(this.getName(), this.getValues()[i], characterSet);
            ++i;
        }
    }

    void claimUniqueValue(List values) {
        boolean[] matches = new boolean[this._optionValues.length];
        int numMatches = 0;
        int i = 0;
        while (i < matches.length) {
            matches[i] = values.contains(this._optionValues[i]);
            if (matches[i]) {
                ++numMatches;
                if (!this._multiSelect) break;
            }
            ++i;
        }
        if (!this._listBox && numMatches == 0) {
            throw new IllegalParameterValueException(this.getName(), (String)values.get(0), this.getOptionValues());
        }
        i = 0;
        while (i < matches.length) {
            if (matches[i]) {
                values.remove(this._optionValues[i]);
            }
            ++i;
        }
        this._selectionIndexes = matches;
        this._values = this.getSelectedValues(matches, this._optionValues);
    }

    void reset() {
        this._selectionIndexes = (boolean[])this._initialIndexes.clone();
        this._values = this.getSelectedValues(this._selectionIndexes, this._optionValues);
    }

    private String[] getSelectedValues(boolean[] selected, String[] optionValues) {
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                values.add(optionValues[i]);
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    private boolean[] getInitialSelectionIndexes(Node selectionNode) {
        boolean noneSelected = true;
        NodeList nl = ((Element)selectionNode).getElementsByTagName("option");
        boolean[] isSelected = new boolean[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getAttributes().getNamedItem("selected") != null) {
                isSelected[i] = true;
                noneSelected = false;
            }
            ++i;
        }
        if (!this._listBox && noneSelected && isSelected.length > 0) {
            isSelected[0] = true;
        }
        return isSelected;
    }

    private String[] getInitialDisplayedOptions(Node node) {
        Vector<String> options = new Vector<String>();
        NodeList nl = ((Element)node).getElementsByTagName("option");
        int i = 0;
        while (i < nl.getLength()) {
            options.addElement(SelectionFormControl.getValue(nl.item(i).getFirstChild()));
            ++i;
        }
        Object[] result = new String[options.size()];
        options.copyInto(result);
        return result;
    }

    private String[] getInitialOptionValues(Node selectNode) {
        NodeList nl = ((Element)selectNode).getElementsByTagName("option");
        ArrayList<String> options = new ArrayList<String>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            options.add(this.getOptionValue(nl.item(i)));
            ++i;
        }
        return options.toArray(new String[options.size()]);
    }

    private String getOptionValue(Node optionNode) {
        NamedNodeMap nnm = optionNode.getAttributes();
        if (nnm.getNamedItem("value") != null) {
            return SelectionFormControl.getValue(nnm.getNamedItem("value"));
        }
        return SelectionFormControl.getValue(optionNode.getFirstChild());
    }

    private static String getValue(Node node) {
        return node == null ? "" : SelectionFormControl.emptyIfNull(node.getNodeValue());
    }

    private static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }
}

